package LIMS::Controller::Roles::User;

use Moose::Role;

has lab_staff => (
    is      => 'ro',
    isa 	=> 'ArrayRef[HashRef]',
    traits  => ['Array'],
    default => sub { [] },
	handles	=> {
        add_lab_staff_user => 'push',
    },
);

sub get_lab_staff_users {
    my $self = shift;

	my $users = $self->model('User')->get_all_users({sort_by => 'username'});

    my @labs = ( $self->cfg('settings')->{lab_name_abbreviation} ); # warn @labs;
    if ( my $central_labs = $self->cfg('settings')->{central_labs} ) { # genomics
        push @labs, split ',', $central_labs;
    };

    for my $user (@$users) {
        next unless $user->active eq 'yes'
            && grep $user->user_location->location_name eq $_, @labs; # warn $user->username;

        my %user = (
            id => $user->id,
            username => $user->username,
        );

        $self->add_lab_staff_user(\%user);
    } # $self->debug($self->lab_staff);

    return $self->lab_staff;
}

#-------------------------------------------------------------------------------
sub generate_new_password {
    my $self = shift;

    srand;

	# assemble list of alphanumeric chars, excluding ambiguous lc(L), uc(o), 0 & 1:
	my @elements = grep m![^lO]!, ( 'a' .. 'z', 'A' .. 'Z', 2 .. 9 );

	# join 10 randomly-selected @elements:
	my $pwd = join '', ( map $elements[ int(rand @elements) ], 1 .. 10 );
	return $pwd;
}

1;
