package LIMS::DB::PatientTrial;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table => 'patient_trial',

    columns => [
        patient_id   => { type => 'integer', not_null => 1 },
        trial_id     => { type => 'integer', not_null => 1 },
        trial_number => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'patient_id', 'trial_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },

        trial => {
            class       => 'LIMS::DB::ClinicalTrial',
            key_columns => { trial_id => 'id' },
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('patient_trial');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('patient_trials');

1;
