package LIMS::DB::LabTestStatusOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_test_status_options',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        description => { type => 'varchar', length => 255, not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
    
    relationships => [
        lab_section_status_option => {
            class      => 'LIMS::DB::LabSectionStatusOption',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },
        lab_tests => {
            map_class => 'LIMS::DB::RequestLabTestStatus',
            map_from  => 'status',
            map_to    => 'lab_test',
            type      => 'many to many',
        },
        request_lab_test_status => {
            class      => 'LIMS::DB::RequestLabTestStatus',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_status_options');

1;
