#!/usr/bin/perl

# just testing for dfv errors using LIMS::Validation profiles:

use Test::WWW::Mechanize::CGIApp;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 22; # use Test::More 'no_plan';

=begin: tests:
1) 
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# patient_search_data profile:
$mech->get_ok('/register');                					 #  print_and_exit();
{
    $mech->submit_form(); # empty
    has_dfv_errors();                                      # print_and_exit();
    
    my %dob = (
        day   => 29, 
        month => 2, 
        year  => 53,    # invalid
    );
    
    # non-standard response to missing fields:
    _test_missing_required(\%dob);                        # print_and_exit();
    
    $mech->submit_form(fields => \%dob);                     # print_and_exit();
    
    has_dfv_errors();
    _format_err_str('invalid &#187;');                       # print_and_exit();
    
    $dob{year} += 1900;
    $mech->submit_form(fields => \%dob);                     # print_and_exit();
    
    # still invalid:
    has_dfv_errors();
    _format_err_str('invalid &#187;');                       # print_and_exit();
    
    # increment to invalid (even-number) leap-year: 
    $dob{year}++;
    $mech->submit_form(fields => \%dob);                     # print_and_exit();
    
    has_dfv_errors();
    _format_err_str('invalid &#187;');                       # print_and_exit();

    # increment to valid leap-year: 
    $dob{year} += 2;
    $mech->submit_form(fields => \%dob);                     # print_and_exit();
    
    lacks_dfv_errors();                                       # print_and_exit();

    $mech->get('/register');                
    # make valid date in future:
    $dob{month}++;
    $dob{year} = DateTime->now->year + 1;

    $mech->submit_form(fields => \%dob);                     # print_and_exit();
    has_dfv_errors();
    _format_err_str('invalid &#187;');                       # print_and_exit();
    
    $dob{year} = DateTime->now->year - 1;
    $mech->submit_form(fields => \%dob);                    #  print_and_exit();
    lacks_dfv_errors();
}

sub _test_missing_required {
	my $data = shift;
	
    # test each required field:
    foreach my $field ( keys %$data ) { # warn $field;
        # create temp hash with one field missing:
        my %tmp = %$data; # clone %data
        $tmp{$field} = undef; # warn Dumper \%tmp_user;

        # jump to correct form:
        $mech->submit_form( fields => \%tmp );                # print_content();
        
        # check we have dfv error:
        has_dfv_errors();
        _format_err_str('invalid &#187;');
    }                                                         
}

sub _format_err_str {
    my $msg = shift;
    
	my $template = '<span class="dfv_errors">%s</span>';
	my $str = sprintf $template, $msg;
    
    $mech->content_contains( $str, 'OK: expected field detected' );
}