DELETE FROM icdo_category;

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),1 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'Precursor cell';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),2 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'B-lymphoproliferative';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),3 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'T-lymphoproliferative';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),4 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'Plasma cell';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),5 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'Myelodysplastic';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),6 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE dc.description = 'Myeloproliferative';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT d.icdo3,6 from diagnoses d WHERE name = 'Myelodysplastic/myeloproliferative neoplasm unclassified';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),9 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE (d.name like 'B-cell chronic%' or d.name like 'B-CLL%' ) and d.active = 'yes';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),10 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id
	WHERE d.name like 'Follicular lymphoma%' and d.active = 'yes';	
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),11 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name like 'AML%' and d.active = 'yes';
	
INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),12 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name regexp 'B-lymphoblastic' and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),13 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name regexp 'marginal zone' and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),14 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name regexp 'Hodgkin' and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),15 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE ( d.name like 'DLBCL%' or d.name like 'Diffuse large B-cell%' ) and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),16 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name like 'Mantle cell%' and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),17 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name regexp 'myeloma' and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),18 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE ( d.name like 'CML%' or d.name like 'Chronic myeloid%' ) and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),19 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE ( d.name like 'MGUS%' or d.name like 'Monoclonal gammopathy%' ) and d.active = 'yes';

INSERT INTO icdo_category (icdo3,diagnostic_category_id) 
	SELECT distinct(d.icdo3),20 from diagnoses d join diagnostic_categories dc on d.diagnostic_category_id = dc.id 
	WHERE d.name regexp 'T-lymphoblastic' and d.active = 'yes';

