package LIMS::Controller::Outreach;

use Moose;
BEGIN { extends 'LIMS::Base' }
with (
    'LIMS::Controller::Roles::Misc', # redirect_after_edit_success()
	'LIMS::Controller::Roles::RecordHandler',
);
use namespace::clean -except => 'meta';

__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
# outreach/=/x should never be called direct - forward to startrunmode:
sub load : Runmode {
    return shift->forward('default');
}

# ------------------------------------------------------------------------------
sub haematology : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift; $self->stash( errs => $errs ); # for debugging in tmpl

    return $self->forbidden() unless $self->user_can('edit_outreach_data');

    my $request_id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);

}

# ------------------------------------------------------------------------------
sub patient_notes : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('edit_outreach_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    my $patient_id = $self->param('Id')
    || return $self->error('no patient_id passed to '.$self->get_current_runmode);

    # only one param passed:
    my $str = $self->query->param('patient_notes');
    
    my %args = (
        patient_id => $patient_id,
        details    => $str,
    );
    
    my $rtn = $self->model('Outreach')->update_patient_notes(\%args);
    return $rtn
        ? $self->error($rtn)
        : $self->redirect_after_edit_success('/report/outreach/' . $request_id);    
}

# ------------------------------------------------------------------------------
sub edit_followup : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;
    
    return $self->forbidden() unless $self->user_can('edit_outreach_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    { # follow-up data:
        my $data = $self->model('Outreach')->get_followup_data($request_id);
        $self->tt_params( followup_data => $data );
    }
    { # request_data:
        my $data
            = $self->model('Request')->get_patient_and_request_data($request_id);
        $self->tt_params( request_data => $data );
    }
    { # follow-up options:
        my $options = $self->model('Outreach')->get_followup_options;
        $self->tt_params( followup_options => $options );        
    }

    $self->js_validation_profile('outreach_followup');

    return $self->tt_process();
}

# ------------------------------------------------------------------------------
sub do_pack_dispatch : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('edit_outreach_data');
    
    my @request_ids = $self->query->param('request_id');
    
    unless (@request_ids) {
        $self->flash( warning => $self->messages('worklist')->{no_request_ids} );
        my $url = join '/', $self->query->url(),
            'local_worklist?function_name=outreach_pack_dispatch';
        return $self->redirect($url);
    }
    
    { # do update; return error if one occured:
        my $rtn = $self->model('Outreach')->do_pack_dispatch(\@request_ids);
        return $self->error($rtn) if $rtn;
    }
    
    { # get data for summary:
        my $data = $self->model('Request')->requests_summary_data(\@request_ids);    
        $self->tt_params( requests => $data );
    }
    return $self->tt_process();
}

# ------------------------------------------------------------------------------
sub do_edit_followup : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('edit_outreach_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
	my $dfv = $self->check_rm('edit_followup', $self->validate('outreach_followup') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid; # warn Dumper $data;
    
    $data->{_request_id} = $request_id;
    
    my $rtn = $self->model('Outreach')->update_followup($data);
    return $rtn
        ? $self->error($rtn)
        : $self->redirect_after_edit_success('/report/outreach/' . $request_id);    
}


1;