package LIMS::Model::ClinicalTrial;

use base 'LIMS::Model::Base';

use strict;

#-------------------------------------------------------------------------------
sub get_trial {
    my ($self, $trial_id) = @_; # DEBUG $trial_id;

    my $data = LIMS::DB::ClinicalTrial->new(id => $trial_id)->load;

    return $data;
}

#-------------------------------------------------------------------------------
sub get_trials {
    my $self = shift;
    
    # get all rows as arrayref:
    my $data = LIMS::DB::ClinicalTrial::Manager
        ->get_clinical_trials(sort_by => 'trial_name'); # DEBUG $data;

    return $data;
}

#-------------------------------------------------------------------------------
sub get_trial_number {
    my ($self, $patient_id, $trial_id) = @_;
    
    my %data = (
        patient_id => $patient_id,
        trial_id   => $trial_id,
    );
    
    my $patient_trial
        = LIMS::DB::PatientTrial->new(%data)->load(speculative => 1);
    
    return $patient_trial ? $patient_trial->trial_number : undef;
}

#-------------------------------------------------------------------------------
sub update_trials {
    my $self = shift;
    my $data = shift; # DEBUG $trial; # return;

    my %args = ( class => 'ClinicalTrial', data  => $data );
    
    return $self->update_object(\%args);
}

1;
