#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use Test::More; #use Test::More 'no_plan';

BEGIN {
    require 't/test-lib.pl';
}


my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

my $dbix = get_dbix();

do_login();

# Admin can access everything
$mech->get_ok('/search/=/1');                               # print_and_exit();
$mech->content_contains(">Storage</a>");
$mech->get_ok('/storage/=/1');                               # print_and_exit();
$mech->content_lacks("Permission Denied");
$mech->submit_form(form_id => 'storageVial', fields => {});                               # print_and_exit();
$mech->content_lacks("Permission Denied");
$mech->content_contains("Error - form validation failed");
#print $mech->text;

# change group id to guest so shouldnt be able to see link or access page
$dbix->query('update users set group_id = 2');
$mech->get_ok('/logout');                               # print_and_exit();
do_login();
$mech->get_ok('/search/=/1');                               # print_and_exit();
$mech->content_lacks(">Storage</a>");
$mech->get_ok('/storage/=/1');                               # print_and_exit();
$mech->content_contains("Permission Denied");

# change group id to guest so shouldnt be able to see link or access page
$mech->get_ok('/logout');                               # print_and_exit();
#  add view_storage so request_link is visible again
$dbix->query("insert into user_functions (function_name, function_detail,active) values ( 'view_storage', 'view storage location information','yes');");
$dbix->query('insert into user_group_function values ( 2,15);');
do_login();
$mech->get_ok('/search/=/1');                               # print_and_exit();
$mech->content_contains(">Storage</a>");
$mech->get_ok('/storage/=/1');                               # print_and_exit();
$mech->content_lacks("Permission Denied");
#print $_->url ."\n" for $mech->links;
#$mech->get_ok('/storage/edit/***/1');                               # print_and_exit();
# form storageVial
$mech->submit_form(form_id => 'storageVial', fields => {});                               # print_and_exit();
$mech->content_contains("Permission Denied");

# change user location
# change group_id
# etc.
$mech->get_ok('/storage/=/1');                               # print_and_exit();

done_testing;
