#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use DateTime;
use Test::More;
use Data::Printer;
use Test::Builder::Tester;
use constant TESTS => 28;

=begin # tests online request form registration import (doesn't create new request):
1) patient already exists on system
2) patient doesn't already exist on system (no middle name)
3) patient doesn't already exist on system (single middle name)
4) patient doesn't already exist on system (multiple middle names)
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();
my $dbix = get_dbix();
my $cfg  = get_config(); # p $cfg->{settings}; exit;
my $now  = DateTime->now;

my %common_fields = (
    location_id => 1, referrer => 'Brown CC [Haematology]',
    location_name => 'Newtown General Infirmary', user_id => 1,
    requested_by => 'Black T',
);

do_login();

{ # patient already exists on system:
    my $lname = 'green';
    my $fname = 'alan';
    my $id = generate_request_form_id({ lname => $lname, fname => $fname });
    my %h = (
        id => $id, last_name => $lname, first_name => $fname, gender => 'M',
        dob => '1950-07-10', nhs_number => 1111111111,
    );
    $dbix->insert('request_form', { %common_fields, %h });
    $mech->get_ok('/register');                              # print_and_exit();
    $mech->form_name('request_form');

    $mech->submit_form( fields => { id => $id } );           # print_and_exit();
    $mech->text_contains(
        "Found 1 record matching name=$lname, $fname & patient_no=1111111111",
        'OK: record loaded',
    );
}

{ # patient doesn't exist on system:
    my $lname = 'silver';
    my $fname = 'june';
    my $id = generate_request_form_id({ lname => $lname, fname => $fname });
    my %h = (
        id => $id, last_name => $lname, first_name => $fname, gender => 'F',
        dob => '1950-09-10', nhs_number => 3333333333,
    );
    $dbix->insert('request_form', { %common_fields, %h });
    $mech->get_ok('/register');                              # print_and_exit();
    $mech->form_name('request_form');

    $mech->submit_form( fields => { id => $id } );           # print_and_exit();
    $mech->content_contains( 'Found 0 records', 'OK: record loaded');
    is( $mech->value('last_name'), $lname, 'OK: expected last name' );
    is( $mech->value('first_name'), $fname, 'OK: expected first name' );
    is( $mech->value('middle_name'), '', 'OK: no middle names' );
}

{ # patient doesn't exist on system (single middle name):
    my $lname = 'brown';
    my $fname = 'mary eve';
    my $id = generate_request_form_id({ lname => $lname, fname => $fname });
    my %h = (
        id => $id, last_name => $lname, first_name => $fname, gender => 'F',
        dob => '1960-03-10', nhs_number => 4444444444,
    );
    $dbix->insert('request_form', { %common_fields, %h });
    $mech->get_ok('/register');                              # print_and_exit();
    $mech->form_name('request_form');

    $mech->submit_form( fields => { id => $id } );           # print_and_exit();
    $mech->content_contains( 'Found 0 records', 'OK: record loaded');
    is( $mech->value('last_name'), $lname, 'OK: expected last name' );
    is( $mech->value('first_name'), 'mary', 'OK: expected first name' );
    is( $mech->value('middle_name'), 'eve', 'OK: expected middle name' );
}

{ # patient doesn't exist on system (multiple middle names):
    my $lname = 'white';
    my $fname = 'april may june';
    my $id = generate_request_form_id({ lname => $lname, fname => $fname });
    my %h = (
        id => $id, last_name => $lname, first_name => $fname, gender => 'F',
        dob => '1940-05-10', nhs_number => 5555555555,
    );
    $dbix->insert('request_form', { %common_fields, %h });
    $mech->get_ok('/register');                              # print_and_exit();
    $mech->form_name('request_form');

    $mech->submit_form( fields => { id => $id } );           # print_and_exit();
    $mech->content_contains( 'Found 0 records', 'OK: record loaded');
    is( $mech->value('last_name'), $lname, 'OK: expected last name' );
    is( $mech->value('first_name'), 'april', 'OK: expected first name' );
    is( $mech->value('middle_name'), 'may june', 'OK: expected middle names' );
}

{ # patient doesn't exist on system (single character middle name):
    my $lname = 'black';
    my $fname = 'david a';
    my $id = generate_request_form_id({ lname => $lname, fname => $fname });
    my %h = (
        id => $id, last_name => $lname, first_name => $fname, gender => 'F',
        dob => '1990-05-10', nhs_number => 6666666666,
    );
    $dbix->insert('request_form', { %common_fields, %h });
    $mech->get_ok('/register');                              # print_and_exit();
    $mech->form_name('request_form');

    $mech->submit_form( fields => { id => $id } );           # print_and_exit();
    $mech->content_contains( 'Found 0 records', 'OK: record loaded');
    is( $mech->value('last_name'), $lname, 'OK: expected last name' );
    is( $mech->value('first_name'), 'david', 'OK: expected first name' );
    is( $mech->value('middle_name'), '', 'OK: no middle name' );
}

sub generate_request_form_id {
    my $vars = shift;

    my $first_name = $vars->{fname};
    my $last_name  = $vars->{lname};
    # id = datetime epoch + last_name + first initial:
    my $id = $now->epoch . uc( $last_name . substr($first_name, 0, 1) );
    return $id;
}

do_logout();
done_testing(TESTS);
