#
#===============================================================================
#
#  DESCRIPTION: rfc418L
#  add timestamp in section worksheets if configured in worklist_cfg.yml
#
#===============================================================================

use HMDS::Perl;

use Test::WWW::Mechanize::CGIApp;
use Test::More;    # tests => 6;
use Test::Exception;
use List::Util qw/any/;
use Data::Printer;

require 't/test-lib.pl';

my $mech = get_mech();

do_login();

# get yaml data for this worklist option
my $yaml = get_yaml('worklist_cfg');
is ref($yaml), 'HASH', 'opened worklist_cfg';
ok exists $yaml->{show_request_lab_test_status_time},
  'show_request_lab_test_status_time set in worklist_cfg.yml'
  or diag
"Need to set 'show_request_lab_test_status_time: []' to show it is intentionally left empty in yaml file";
my @sections_requiring_status_times =
  @{ $yaml->{show_request_lab_test_status_time} };
my @sections_no_time = 'fake_section'; # check when not showing status times

# setup database
my $dbh;

lives_ok { $dbh = get_dbh() or die 'no database handle received from get_dbh'; }
'Database handle recieved';
my $dbix = get_dbix();

# need requests-lab_tests to satisfy get_outstanding_investigations
#  e.g. hts section and not complete

foreach my $section_name ( @sections_requiring_status_times, @sections_no_time )
{

    # get section id or insert new section
    my $section_id =
      $dbix->query( 'select id from lab_sections where section_name = ?',
        $section_name )->list;
    if ( not defined($section_id) ) {

        # lab section hts
        my %args = (
            section_name       => $section_name,
            has_result_summary => 'yes',
            has_section_notes  => 'yes',
            has_test_sign_out  => 'no',
            has_foreign_id     => 'yes',
            has_results_import => 'no',
            has_labels         => 'no',
            auto_expand        => 'no',
            is_active          => 'yes',
        );
        $dbix->insert( 'lab_sections', \%args );
        $section_id = $dbh->last_insert_id( undef, undef, undef, undef );
    }
    {    # create some tests for each section

        foreach (qw/foo/) {
            my %args = (
                test_name      => $_,
                field_label    => uc,
                lab_section_id => $section_id,
                test_type      => 'test',
                has_results    => 'no',
                is_active      => 'yes',

            );
            $dbix->insert( 'lab_tests', \%args );
            my $hts_test_id =
              $dbh->last_insert_id( undef, undef, undef, undef );

            # create some request_lab_test_status mappings
            my %status_args = (
                request_id       => 1,
                lab_test_id      => $hts_test_id,
                status_option_id => 1,
                user_id          => 1,

                # set time for easy testing
                time => '2018-05-18 13:35:46',
            );
            $dbix->insert( 'request_lab_test_status', \%status_args );
        }
    }
}


foreach my $section ( @sections_requiring_status_times, @sections_no_time ) {
    # test default runmode
    $mech->get_ok('/worklist');
    $mech->content_like( qr{Lab section worksheets:},
        'Loaded worklists page', );
    $mech->content_contains( $section, "Worklists section found: $section", );

    # test worklist displays  worklist:
    ok $mech->form_name('worklist'), 'worklist form is in page';
    ok $mech->select( lab_section_id => $section ),
      "$section worksheet is selected";

    $mech->submit();

    # test select runmode
    ok $mech->form_name('display'), 'display form is in page';
    $mech->submit();

    # test display runmode
    $mech->text_contains( q(FOO), 'test displayed', );
    if ( any { $_ eq $section } @sections_requiring_status_times ) {
        $mech->text_contains( q{Status Date}, 'date column displayed', );
        $mech->text_contains( q{18/05/2018},  'date displayed correctly', );
    }
    else {
        $mech->text_lacks( q(Status Date), 'date column not displayed', );
    }

}
done_testing();
