/* change field-labels */
UPDATE lab_tests SET field_label = 'Cytocell 11q23'    
	WHERE lab_section_id = 7 AND test_name = '11q23';
UPDATE lab_tests SET field_label = 'Cytocell 11q24'     
	WHERE lab_section_id = 7 AND test_name = '11q24';
UPDATE lab_tests SET field_label = 'Cytocell 13q14 DLEU7'     
	WHERE lab_section_id = 7 AND test_name = '13q14_dleu7';
UPDATE lab_tests SET field_label = 'Cytocell 13q14 Rb' 	
	WHERE lab_section_id = 7 AND test_name = '13q14_rb';
UPDATE lab_tests SET field_label = 'Cytocell 1p32.3 (CDKN2C)' 
	WHERE lab_section_id = 7 AND test_name = 'cdkn2c';
UPDATE lab_tests SET field_label = 'Cytocell 1q21 (CKS1B)' 
	WHERE lab_section_id = 7 AND test_name = 'cks1b';
UPDATE lab_tests SET field_label = 'Abbott 5p15 (control)' 
	WHERE lab_section_id = 7 AND test_name = 'alpha5';
UPDATE lab_tests SET field_label = 'Abbott 5q31' 
	WHERE lab_section_id = 7 AND test_name = '5q31';
UPDATE lab_tests SET field_label = 'Abbott 7q31' 
	WHERE lab_section_id = 7 AND test_name = '7q31';
UPDATE lab_tests SET field_label = 'Abbott CEN11' 
	WHERE lab_section_id = 7 AND test_name = 'alpha11';
UPDATE lab_tests SET field_label = 'Cytocell CEN12' 
	WHERE lab_section_id = 7 AND test_name = 'alpha12';
UPDATE lab_tests SET field_label = 'Cytocell CEN17' 
	WHERE lab_section_id = 7 AND test_name = 'alpha17';
UPDATE lab_tests SET field_label = 'Abbott CEN18' 
	WHERE lab_section_id = 7 AND test_name = 'alpha18';
UPDATE lab_tests SET field_label = 'Abbott CEN7' 
	WHERE lab_section_id = 7 AND test_name = 'alpha7';
UPDATE lab_tests SET field_label = 'Abbott CEN8' 
	WHERE lab_section_id = 7 AND test_name = 'alpha8';
UPDATE lab_tests SET field_label = 'DAKO BCL2' 
	WHERE lab_section_id = 7 AND test_name = 'bcl2';
UPDATE lab_tests SET field_label = 'Abbott BCL2/IGH' 
	WHERE lab_section_id = 7 AND test_name = 'bcl2_igh';
UPDATE lab_tests SET field_label = 'DAKO BCL6' 
	WHERE lab_section_id = 7 AND test_name = 'bcl6';
UPDATE lab_tests SET field_label = 'Abbott BCR-ABL' 
	WHERE lab_section_id = 7 AND test_name = 'bcr_abl';
UPDATE lab_tests SET field_label = 'DAKO CCND1' 
	WHERE lab_section_id = 7 AND test_name = 'bcl1';
UPDATE lab_tests SET field_label = 'Abbott CCND1/IGH' 
	WHERE lab_section_id = 7 AND test_name = 'bcl1_igh';
UPDATE lab_tests SET field_label = 'Cytocell CCND2' 
	WHERE lab_section_id = 7 AND test_name = 'ccnd2';
UPDATE lab_tests SET field_label = 'Cytocell DUSP22/IRF4' 
	WHERE lab_section_id = 7 AND test_name = 'dusp22_irf4';
UPDATE lab_tests SET field_label = 'Zytolight FGFR3' 
	WHERE lab_section_id = 7 AND test_name = 'fgfr3';
UPDATE lab_tests SET field_label = 'Cytocell FGFR3/IGH' 
	WHERE lab_section_id = 7 AND test_name = 'fgfr3_igh';
UPDATE lab_tests SET field_label = 'Cytocell IGH' 
	WHERE lab_section_id = 7 AND test_name = 'igh';
UPDATE lab_tests SET field_label = 'Cytocell IGH/MAFB' 
	WHERE lab_section_id = 7 AND test_name = 'igh_mafb';
UPDATE lab_tests SET field_label = 'Cytocell IGK' 
	WHERE lab_section_id = 7 AND test_name = 'ig_kappa';
UPDATE lab_tests SET field_label = 'Cytocell IGL' 
	WHERE lab_section_id = 7 AND test_name = 'ig_lambda';
UPDATE lab_tests SET field_label = 'Abbott KMT2A (MLL)' 
	WHERE lab_section_id = 7 AND test_name = 'mll';
UPDATE lab_tests SET field_label = 'Cytocell MAF/IGH' 
	WHERE lab_section_id = 7 AND test_name = 'maf_igh';
UPDATE lab_tests SET field_label = 'DAKO MALT1' 
	WHERE lab_section_id = 7 AND test_name = 'malt1';
UPDATE lab_tests SET field_label = 'DAKO MYC' 
	WHERE lab_section_id = 7 AND test_name = 'cmyc';
UPDATE lab_tests SET field_label = 'Abbott MYC/IGH' 
	WHERE lab_section_id = 7 AND test_name = 'cmyc_igh';
UPDATE lab_tests SET field_label = 'Abbott PDGFRA-FIP1L1' 
	WHERE lab_section_id = 7 AND test_name = 'pdgfra_fip1l1';
UPDATE lab_tests SET field_label = 'Cytocell PML/RARa' 
	WHERE lab_section_id = 7 AND test_name = 'pml_rar_alpha';
UPDATE lab_tests SET field_label = 'Cytocell TCL1' 
	WHERE lab_section_id = 7 AND test_name = 'tcl1';
UPDATE lab_tests SET field_label = 'Cytocell TP53' 
	WHERE lab_section_id = 7 AND test_name = 'p53';
UPDATE lab_tests SET field_label = 'Cytocell TP63 (6p25)' 
	WHERE lab_section_id = 7 AND test_name = 'tp63_6p25';
UPDATE lab_tests SET field_label = 'Burkitt 11q' 
	WHERE lab_section_id = 7 AND test_name = '11q';

/* inactivate lab-tests */
UPDATE lab_tests SET is_active = 'no' 
	WHERE lab_section_id = 7 AND test_name IN (
    '13q14', '13q34', '6q21', 'alpha3', 'alpha6', 'bcl3', 'fish', 'atm',
    'foxp1', 'pax5', 'cll', 'myeloma_trial', 'plasma_cell_screen'
);

/* new lab-tests */
INSERT INTO lab_tests(test_name,field_label,lab_section_id,test_type,has_results,is_active) 
  VALUES
    ('abbott_bcl6','Abbott BCL6',7,'test','yes','yes'),
    ('abbott_bcl2','Abbott BCL2',7,'test','yes','yes'),
    ('abbott_fgfr3_igh','Abbott FGFR3/IGH',7,'test','yes','yes'),
    ('abbott_maf_igh','Abbott MAF/IGH',7,'test','yes','yes'),
    ('dako_igh','DAKO IGH',7,'test','yes','yes'),
    ('cytocell_myc','Cytocell MYC',7,'test','yes','yes'),
    ('cytocell_atm','Cytocell ATM',7,'test','yes','yes'),
    ('cytocell_cen11','Cytocell CEN11',7,'test','yes','yes'),
    ('cytocell_bcr_abl','Cytocell BCR-ABL',7,'test','yes','yes'),
    ('cytocell_kmt2a','Cytocell KMT2A',7,'test','yes','yes'),
    ('cytocell_ccnd1_igh','Cytocell CCND1/IGH',7,'test','yes','yes'),
    ('dlbcl_burkitt_fresh','DLBCL v Burkitt (fresh)',7,'panel','no','yes'),
    ('dlbcl_extended_fresh','DLBCL extended (fresh)',7,'panel','no','yes'),
    ('dlbcl_screen_fresh','DLBCL screen (fresh)',7,'panel','no','yes'),
    ('dlbcl_fl_fresh','DLBCL + FL (fresh)',7,'panel','no','yes');

/* lab-test-sample-types & lab_test_data_types */
SELECT @data_type_id := id FROM lab_test_result_data_types
    WHERE description = 'fish_text';
SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'abbott_bcl6';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'abbott_bcl2';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'abbott_fgfr3_igh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'abbott_maf_igh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'dako_igh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_myc';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_atm';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_cen11';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_bcr_abl';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_kmt2a';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'cytocell_ccnd1_igh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'dlbcl_burkitt_fresh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'dlbcl_extended_fresh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'dlbcl_screen_fresh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');

SELECT @lab_test_id := id FROM lab_tests WHERE test_name = 'dlbcl_fl_fresh';
INSERT INTO lab_test_sample_type(lab_test_id, sample_type_id) VALUES
    (@lab_test_id,1),
    (@lab_test_id,2),
    (@lab_test_id,3);    
INSERT INTO lab_test_data_type(lab_test_id, data_type_id, is_active)
VALUES (@lab_test_id,@data_type_id,'yes');


# configure panel-lab-tests manually
