#!/usr/bin/perl

use strict;
use warnings;

use lib '/home/raj/perl5/lib/perl5';
use Data::Dumper;

use FindBin qw($Bin); # warn $Bin;
use lib "$Bin/../../../lib";
use LIMS::Local::ScriptHelpers;

#-------------------------------------------------------------------------------
unless (@ARGV) { $ARGV[0] = 'leeds' }
#-------------------------------------------------------------------------------

my %db_map = ( leeds => 'hilis4' ); # map 'leeds' => 'hilis4, all others = $ARGV[0]

use constant DELTA => 6; # months since last login to inactivate account

# get tools from LIMS::Local::ScriptHelpers:
my $tools = LIMS::Local::ScriptHelpers->new();

my $filename = $tools->script_filename;
my $sql_lib  = $tools->sql_lib();
my $dbix     = $tools->dbix();
my $dbh      = $dbix->dbh();

# get sql statments:
my $sql = $sql_lib->retr( 'expire_user_accounts' ); # warn $sql; warn DELTA; exit;

for my $centre (@ARGV) { # print $fh Dumper $centre;
	my $i = 0; # numerical return from dbh->do()

    my $db = $db_map{$centre} || $centre;
	$dbh->do( 'use ' . $db ); # switch db

	# execute query:
	$i += $dbh->do($sql, undef, DELTA); # warn Dumper $i;
    print "$filename inactivated $i $centre HILIS4 accounts\n" if $i;
}

{ # draft_report_users (only Leeds/HMDS using it):
    my $i = 0; # row counter
    # clone global $sql so that change doesn't persist outside block:
    my $draft_report_users_query = $sql;
    $draft_report_users_query =~ s/users/draft_report_users/;
	$dbh->do( 'use hilis4' ); # switch db
	$i += $dbh->do($draft_report_users_query, undef, DELTA); # warn Dumper $i;
    print "$filename inactivated $i leeds draft-report-user accounts\n" if $i;
}
