package LIMS::DB::RequestTrial;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table => 'request_trial',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        trial_id   => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        trial => {
            class       => 'LIMS::DB::ClinicalTrial',
            key_columns => { trial_id => 'id' },
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('request_trial');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_trials');

1;
