package LIMS::DB::RequestSecondaryDiagnosis;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_secondary_diagnosis',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        secondary_diagnosis_id  => { type => 'integer', not_null => 1 },
        time                    => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { secondary_diagnosis_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('request_secondary_diagnoses');

1;
