package LIMS::DB::PatientDemographicHistory;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'patient_demographic_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        patient_id => { type => 'integer', not_null => 1 },
        action     => { type => 'varchar', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patientt',
            key_columns => { patient_id => 'id' },
            rel_type    => 'one to one',
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('request_trial');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('patient_demographic_histories');

1;
