package LIMS::Controller::Admin::Lab::Test::StatusOptions;

use strict;

use base 'LIMS::Controller::Admin';
use Data::Dumper;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    { # get list of status options table data:
        my $options = $self->model('LabTest')->get_status_options;
        # re-order alphabetically (1st 3 default opts remain in order):
        my @opts = map shift @{$options}, 1..3; # warn Dumper \@opts;
        push @opts, sort { lc $a->description cmp lc $b->description } @$options;
        $self->tt_params( status_options => \@opts );
    }
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('status_options');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $option = $self->model('LabTest')->get_status_option($id);
    $self->tt_params( data => $option );

    { # can this entry be edited/deleted?
        my $in_use = $self->model('Result')->get_status_option_count($option->id);
        $self->tt_params( in_use => $in_use );
    }

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('status_options');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub delete { # not implemented yet
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');

	# put id (if submitted) into params() as _record_id for validation:
    if ( $id ) {
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('status_options') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created:
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('LabTest')->update_status_options($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		# set success msg:
		my $msg = $id ? 'edit_success' : 'create_success';
		$self->flash( info => $self->messages('action')->{$msg} );
		return $self->redirect( $self->query->url . '/admin/lab_test_status-options' ); # safer to redirect after db edit
	}
}

1;
