package LIMS::Controller::Admin::Config::Settings;

use strict;

use base 'LIMS::Base';

use Config::Tiny;
use Data::Printer;
use LIMS::Local::Utils;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    # retrieve settings from file:
    my $settings = $self->_get_settings();

    $self->tt_params(
        settings => $settings->{local_admin},
        sysadmin => $settings->{sys_admin},
    );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('js_config_settings');

    return $self->tt_process( 'admin/config/settings.tt' );
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $profile = $self->validate('config_settings_profile'); # arrayref

    my $result = $self->form_validator($profile);
    return $self->forward('default') if $result->has_error;

    my $vars = $result->valid; # $self->debug($vars);

    # retrieve settings from file:
    my $all_settings = $self->_get_settings(); # $self->debug($all_settings);

    # only want to update [local_admin] settings:
    my @local_fields = keys %{ $all_settings->{local_admin} }; # $self->debug(\@local_fields);

    # update $all_settings->{local_admin} with values from form:
    map {
        $all_settings->{local_admin}->{$_} = $vars->{$_};
    } @local_fields; #  $self->debug($all_settings);

    # write settings file back to disk:
    my $settings_file = $self->_get_settings_file();
    $all_settings->write($settings_file);

    { # set confirmation messages:
        my $msgs = $self->messages('admin')->{settings};
        $self->flash( info    => $msgs->{update_successful} );
        $self->flash( warning => $msgs->{require_restart}   );
    }
    return $self->redirect( $self->query->url . '/config/settings' );
}

=begin
# TODO: saving removes comments from config file, can't handle url paths
# (eg /resources/dashboard), won't allow empty field eg smtp_server (commented
# out in genomics.txt), requires all entries in validation block
#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $profile = $self->validate('config_settings_profile'); # arrayref
    my $result  = $self->form_validator($profile);
    return $self->forward('default') if $result->has_error;

    my $vars = $result->valid; # p $vars;

    # retrieve settings from config file:
    my $all_settings = $self->_get_settings(); # p $all_settings;

    my $form_params = $self->query->Vars; # p $form_params;
    # if new param submitted:
    if ( my $param_name = $form_params->{new_param_name} ) {
        my $param_value = $form_params->{new_param_value};
        # add new param to $all_settings->{sys_admin}:
        $all_settings->{sys_admin}->{$param_name} = $param_value;
        delete $form_params->{$_} for qw/new_param_name new_param_value/;
    }

    # merge form_params not already validated (can't validate sysadmin as they
    # vary between centres):
    $vars->{$_} = $form_params->{$_}
        for grep { ! $vars->{$_} } keys %$form_params; # p $vars;
    for my $section( qw/local_admin sys_admin/ ) {
        my @fields = keys %{ $all_settings->{$section} }; # p \@fields;
        # update $all_settings->{$section} with values from form:
        map {
            $all_settings->{$section}->{$_} = $vars->{$_};
        } @fields;
    } # p $all_settings;
    # write settings file back to disk:
    my $settings_file = $self->_get_settings_file();
    $all_settings->write($settings_file);

    { # set confirmation messages:
        my $msgs = $self->messages('admin')->{settings};
        $self->flash( info    => $msgs->{update_successful} );
        $self->flash( warning => $msgs->{require_restart}   );
    }
    return $self->redirect( $self->query->url . '/config/settings' );
}
=cut

#-------------------------------------------------------------------------------
sub _get_settings {
    my $self = shift; $self->_debug_path();

    my $settings_file = $self->_get_settings_file();
    my $settings = Config::Tiny->read($settings_file); # $self->debug($settings);

    return $settings;
}

#-------------------------------------------------------------------------------
sub _get_settings_file {
    my $self = shift; $self->_debug_path();
    
    my $centre = $self->cfg('settings')->{_centre}; # warn $centre;
    my $path_to_app_root = $self->cfg('path_to_app_root');
    
    my $file = sprintf '%s/config/settings/%s.txt',
        $path_to_app_root, $centre; # 'centre' defined in lims_config.pl    
    return $file;
}

1;
