package LIMS::DB::ResultSummaryLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'result_summary_lab_test',

    columns => [
        result_summary_id  => { type => 'integer', not_null => 1 },
        lab_test_id        => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'result_summary_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        result_summary => {
            class       => 'LIMS::DB::ResultSummaryOption',
            key_columns => { result_summary_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('result_summary_lab_tests');

1;
