package LIMS::DB::Outreach::QuestionnaireAdenopathy;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_adenopathy',
    
    columns => [
        request_id      => { type => 'integer', not_null => 1 },
        nodal_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'nodal_option_id' ],

    foreign_keys => [
        nodal_option => {
            class       => 'LIMS::DB::Outreach::NodalOption',
            key_columns => { nodal_option_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('questionnaire_adenopathy');

1;
