package LIMS::DB::LabSectionSampleType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_section_sample_type',

    columns => [
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        sample_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'sample_type_id', 'lab_section_id' ],

    foreign_keys => [
        sample_type => {
            class       => 'LIMS::DB::SampleType',
            key_columns => { sample_type_id => 'id' },
        },
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_section_sample_types');

1;