package LIMS::DB::AdminMessage;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'admin_messages',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        message     => { type => 'text', length => 65535 },
        user_group  => {
            type => 'enum',
            check_in => [ 'internal', 'external', 'all' ],
            default => 'all',
        },
        valid_until => { type => 'date' },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

__PACKAGE__->meta->make_manager_class('admin_messages');

1;


