package LIMS::DB::NGISLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'ngis_lab_test',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        lab_test_id    => { type => 'integer', not_null => 1 },
        ngis_test_code => { type => 'varchar', length => 6, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'lab_test_id', 'ngis_test_code' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('ngis_lab_tests');

1;
