#!/usr/bin/perl

# just testing for dfv errors using LIMS::Validation profiles:

use Test::WWW::Mechanize::CGIApp;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 161; # use Test::More 'no_plan';

=begin: tests:
1) 
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# screening_terms profile:
$mech->get_ok('/admin/screen_term');                          # print_and_exit();
{
    my %screen_term = (
        description => 'AML', # duplicate
        category_id => 1, # fresh
        active => 'yes',
    );
    
    test_missing_required(\%screen_term);                     # print_and_exit();
 
    $mech->submit_form(fields => \%screen_term);             #  print_and_exit();
    
    has_dfv_errors();
    has_duplicate();

    $screen_term{description} = 'APML'; 
    $mech->submit_form(fields => \%screen_term);              # print_and_exit();
    
    lacks_dfv_errors(); 
    lacks_duplicate();
} 

# edit screening term:
{
    my $id = get_last_insert_id('screens'); 
    $mech->get_ok('/admin/screen_term/edit/'.$id);            # print_and_exit();
    
    # change name to duplicate:
    $mech->field(description => 'AML');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();

    # revert name:
    $mech->field(description => 'APML');
    # change active to 'no':
    $mech->field(active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors();
    lacks_duplicate();
}

# lab_tests profile:
$mech->get_ok('/admin/lab_test');                             # print_and_exit();
{
    my %lab_test = (
        field_label => 'AML', # duplicate for lab_section_id = 1 & type = 'panel'
        test_name   => 'aml', 
        lab_section_id => 1,
        test_type => 'panel',
        has_results => 'yes',
        is_active => 'yes',
    );
    
    test_missing_required(\%lab_test);                        # print_and_exit();
 
    $mech->submit_form(fields => \%lab_test);                 # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    $mech->field(field_label => 'exceeds max length 25 chars'); # invalid
    $mech->submit_form();                                    #  print_and_exit();

    has_dfv_errors();
    $mech->content_contains(
        dfv_format('too_long'),
        'OK: max field length exceeded',
    );                                                       #  print_and_exit();
    
    # revert to original, send invalid test_name & change lab_section_id:
    $mech->field(field_label => 'AML'); 
    $mech->field(lab_section_id => 2);
    $mech->field(test_name => 'AML with space'), # capitals & has space
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    $mech->content_contains(
        dfv_format('single_word'),
        'OK: no spaces allowed',
    );                                                        # print_and_exit();

    $mech->field(test_name => 'AML'), # capitals - check validator transforms lc
    $mech->submit_form();                                     # print_and_exit();

    $mech->content_lacks(
        q!name="test_name" value="AML"!, # this test IS case-sensitive
        'OK: upper case test name not present',
    );                                                        # print_and_exit();
    lacks_dfv_errors();
} 

# edit lab_test:
{
    my $last_insert_id = get_last_insert_id('lab_tests'); 
    $mech->get_ok('/admin/lab_test/edit/'.$last_insert_id);  #  print_and_exit();
    
    # change lab_section_id from 2 -> 1 to create duplicate:
    $mech->field(lab_section_id => 1);                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); # 20
    has_duplicate(); # 21

    # revert lab_section_id:
    $mech->field(lab_section_id => 2);
    # change active to 'no':
    $mech->field(is_active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); # 22
    lacks_duplicate(); # 23                                    
}

# lab_section profile:
$mech->get_ok('/admin/lab_section');                          # print_and_exit();
{
    my %lab_section = (
        section_name => 'Flow', # duplicate
        is_active    => 'yes',
        has_result_summary => 'yes',
        sample_type_id => 1,
    );
    
    test_missing_required(\%lab_section);                     # print_and_exit();
 
    $mech->submit_form(fields => \%lab_section);             #  print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    # submit valid form:
    $mech->field(section_name => 'FISH'); 
    $mech->submit_form();                                    #  print_and_exit();
    
    lacks_dfv_errors();
} 

# edit lab_section:
{
    my $id = get_last_insert_id('lab_sections'); # warn $id;

    $mech->get_ok('/admin/lab_section/edit/'.$id);            # print_and_exit();
    # change section_name to duplicate:
    $mech->field(section_name => 'Histology');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); 
    has_duplicate(); 

    # revert section_name:
    $mech->field(section_name => 'FISH');
    # change active to 'no':
    $mech->field(is_active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); 
    lacks_duplicate();                                     
}

# result_summary_options:
$mech->get_ok('/config/result-summary-options');              # print_and_exit();
{
    $mech->field(id => 1);
    $mech->submit();                                         # print_and_exit();
    
    my %new = (
        description => 'Normal', # duplicate for lab_section_id = 1
        lab_section_id => 1,
        # is_active => 'yes', # can't test this as it defaults to 'yes'
    );

    test_missing_required(\%new, 'result_summary_option');    # print_and_exit();
    
    $mech->form_name('result_summary_option');               
    $mech->submit_form(fields => \%new);                      # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();
    
    # get original form back & change description to unique:
    $mech->get('/config/result-summary-options');             # print_and_exit();
    $mech->field(id => 1);    
    $mech->submit_form();
    
    $mech->form_name('result_summary_option');               
    $new{description} = 'Abnormal';                           # print_and_exit();
    $mech->submit_form(fields => \%new);                      # print_and_exit();
    
    lacks_dfv_errors();
    lacks_duplicate();                                        # print_and_exit();
}

# edit result_summary_option:
{
    my $id = get_last_insert_id('result_summary_options');
    $mech->get('/config/result-summary-options/edit/'.$id);   # print_and_exit();
    
    # change decription to duplicate for lab_section:
    $mech->field(description => 'Normal');
    $mech->submit_form();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();
    
    # change lab_section_id to make duplicate description unique:
    $mech->field(lab_section_id => 2);
    $mech->submit_form();
    
    lacks_dfv_errors();
    lacks_duplicate();                                        # print_and_exit();
}

=begin # user_function profile (now disabled):
$mech->get_ok('/admin/user_function');                        # print_and_exit();
{
    my %user_function = (
        function_name   => 'register', # duplicate
        function_detail => 'a new function',
        active          => 'yes',
    );
    
    test_missing_required(\%user_function);                   # print_and_exit();
 
    $mech->submit_form(fields => \%user_function);            # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    $mech->field(function_name => 'has space'); # invalid
    $mech->submit_form();                                     # print_and_exit();
    
    has_dfv_errors();
    $mech->content_contains(
        dfv_format('single_word'),
        'OK: invalid format detected',
    );                                                        # print_and_exit();
    
    $mech->field(function_name => 'new_function'); # valid
    $mech->field(function_detail => 'register requests'); # duplicate
    
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();
    
    # submit valid form:
    $mech->field(function_detail => 'a new function'); 
    $mech->submit_form();                                     # print_and_exit();
    
    lacks_dfv_errors();
} 
=cut

# get last_insert_id:
{
    # edit new user_function:
    my $last_insert_id = get_last_insert_id('user_functions'); 
    $mech->get_ok('/admin/user_function/edit/'.$last_insert_id); # print_and_exit();

    # change function_name to duplicate:
    $mech->field(function_name => 'screen');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); 
    has_duplicate(); 

    # revert function_name:
    $mech->field(function_name => 'new_function');
    # make function_detail duplicate:    
    $mech->field(function_detail => 'register requests'); 
    
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    # revert function_detail:    
    $mech->field(function_detail => 'a new function'); 
    # change active to 'no':
    $mech->field(active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); 
    lacks_duplicate();                                     
}

# user_location profile:
$mech->get_ok('/admin/user_location');                        # print_and_exit();
{
    my %user_location = (
        location_name   => 'HMDS', # duplicate
        active          => 'yes',
    );
    
    test_missing_required(\%user_location);                   # print_and_exit();
 
    $mech->submit_form(fields => \%user_location);            # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    $mech->field(location_name => 'Bradford'); # valid
    $mech->submit_form();                                     # print_and_exit();
    
    lacks_dfv_errors();
} 

# edit user_location:
$mech->get_ok('/admin/user_location/edit/2');                 # print_and_exit();
{
    # change location_name to duplicate:
    $mech->field(location_name => 'HMDS');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); 
    has_duplicate(); 

    # revert location_name:
    $mech->field(location_name => 'Bradford');
    # change active to 'no':
    $mech->field(active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); 
    lacks_duplicate();                                     
}

# user_group profile:
$mech->get_ok('/admin/user_group');                           # print_and_exit();
{
    my %user_group = (
        group_name   => 'bms', # duplicate
        group_label  => 'Secretary',
        group_detail => 'secretary description',
        active       => 'yes',
    );
    
    test_missing_required(\%user_group);                      # print_and_exit();
 
    $mech->submit_form(fields => \%user_group);               # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    $mech->field(group_name => 'has space'); # invalid
    $mech->submit_form();                                     # print_and_exit();
    
    has_dfv_errors();
    $mech->content_contains(
        dfv_format('no_spaces'),
        'OK: invalid format detected',
    );                                                        # print_and_exit();
    
    $mech->field(group_name => 'secretary'); # valid
    $mech->field(group_label => 'BMS'); # duplicate
    
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();
    
    # submit valid form:
    $mech->field(group_label => 'Secretary'); 
    $mech->submit_form();                                     # print_and_exit();
    
    lacks_dfv_errors();
} 

# get last_insert_id:
my $id = get_last_insert_id('user_groups'); # warn $id;
# edit user_group:
$mech->get_ok('/admin/user_group/edit/'.$id);                 # print_and_exit();
{
    # change group_name to duplicate:
    $mech->field(group_name  => 'bms');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); 
    has_duplicate(); 

    # revert group_name:
    $mech->field(group_name => 'secretary');
    # make group_label duplicate:    
    $mech->field(group_label => 'BMS'); 
    
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    # revert group_label:    
    $mech->field(group_label => 'Secretary'); 
    # change active to 'no':
    $mech->field(active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); 
    lacks_duplicate();                                     
}

# user_group profile:
$mech->get_ok('/admin/user');                                 # print_and_exit();
{
    my %new_user = (
        username        => 'admin', # duplicate
        first_name      => 'bilbo',
        last_name       => 'baggins',
        password        => 'password',
        user_location_id => 1,
		designation     => 'test_user',
        group_id        => 2,
        email           => 'user@example.com',
        active          => 'yes',
    );
    
    # non-standard form submission (need to specify form name):
    test_missing_required(\%new_user, 'user_update');         # print_and_exit();
    
    $mech->form_name('user_update');
    $mech->submit_form(fields => \%new_user);                 # print_and_exit();
    
    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    $mech->form_name('user_update');
    $mech->field(username => 'baggins'); # valid
    $mech->field(last_name => 'has space'); # invalid
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    $mech->content_contains(
        dfv_format('username'),
        'OK: invalid format detected',
    );                                                        # print_and_exit();
    
    $new_user{username} = 'baggins'; # valid
    $new_user{email} = 'admin@here.com'; # duplicate     
    $mech->form_name('user_update');
    $mech->submit_form(fields => \%new_user);                 # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();
    
    # submit valid form:
    $new_user{email} = 'bilbo@theshire.com';     
    $mech->form_name('user_update');
    $mech->submit_form(fields => \%new_user);                 # print_and_exit();
    
    lacks_dfv_errors();
    $mech->content_contains(
        get_messages('admin')->{user}->{create_success},
        'OK: expected flash message detected',
    );
} 

# edit new user:
$mech->get_ok('/admin/user');                                 # print_and_exit();
{
    $mech->field(id => 2);
    $mech->submit_form();                                     # print_and_exit();
    
    # check we have expected user:
    $mech->content_contains(
        q!name="username" value="baggins"!,
        'OK: expected username loaded',
    );
    
    # change username to duplicate:
    $mech->form_name('user_update');
    $mech->field(username  => 'admin');                               
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors(); 
    has_duplicate(); 

    # revert username:
    $mech->form_name('user_update');
    $mech->field(username  => 'baggins');                               
    # make email duplicate:    
    $mech->form_name('user_update');
    $mech->field(email => 'admin@here.com'); 
    
    $mech->submit_form();                                     # print_and_exit();

    has_dfv_errors();
    has_duplicate();                                          # print_and_exit();

    # revert email:    
    $mech->form_name('user_update');
    $mech->field(email => 'bilbo@theshire.com'); 
    # change active to 'no':
    $mech->field(active => 'no');
    $mech->submit_form();                                     # print_and_exit();

    lacks_dfv_errors(); 
    $mech->content_contains(
        get_messages('admin')->{user}->{edit_success},
        'OK: expected flash message detected',
    );
}

# edit new user through user.id:
$mech->get_ok('/admin/user/default/2');                       # print_and_exit();
{
    # check we have expected user:
    $mech->content_contains(
        q!name="username" value="baggins"!,
        'OK: expected username loaded',
    );

    # check we can change email OK:
    $mech->form_name('user_update');
    $mech->field(email => 'bilbo@here.com'); 
    
    $mech->submit_form();                                     # print_and_exit();
    
    lacks_dfv_errors(); 
    $mech->content_contains(
        get_messages('admin')->{user}->{edit_success},
        'OK: expected flash message detected',
    );

    $mech->get('/admin/user/default/2');                      # print_and_exit();
    # check we have expected user:
    $mech->content_contains(
        q!name="username" value="baggins"!,
        'OK: expected username loaded',
    );

    # check we can change password OK:
    $mech->form_name('user_update');
    $mech->field(password => 'new_password'); 
    
    $mech->submit_form();                                     # print_and_exit();
    
    lacks_dfv_errors(); 
    $mech->content_contains(
        get_messages('admin')->{user}->{edit_success},
        'OK: expected flash message detected',
    );
}
