package LIMS::DB::ContextWarningDiagnosis;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'context_warning_diagnosis',

    columns => [
        id                  => { type => 'serial', not_null => 1 },
        diagnosis_id        => { type => 'integer', not_null => 1 },
        context_warning_id  => { type => 'integer', not_null => 1 },
    ],

    unique_keys => [ 'diagnosis_id' ],

    foreign_keys => [
        context_warning => {
          class       => 'LIMS::DB::DiagnosisContextWarning',
          key_columns => { context_warning_id => 'id' },
        },
        diagnosis => {
          class       => 'LIMS::DB::Diagnosis',
          key_columns => { diagnosis_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('context_warning_diagnosis');

1;
