// FormValidator.js - packed by http://javascriptcompressor.com
if(typeof Data=="undefined")var Data={};Data.FormValidator=function(){var profile_file,profiles,defaults;this.profile_file=profile_file;this.profiles=profiles;this.defaults=defaults};Data.FormValidator.VERSION='0.06';Data.FormValidator.prototype.validate=function(frmObj,profile){var data_set=this.check(frmObj,profile);var returnVal=new Array();returnVal[0]=data_set.valid();returnVal[1]=data_set.missing();returnVal[2]=data_set.validate_invalid||new Array();returnVal[3]=data_set.unknown();return returnVal};Data.FormValidator.prototype.check=function(frmObj,profile){var defaults=new Object();defaults.profile_file=this.profile_file;defaults.profiles=this.profiles;defaults.defaults=this.defaults;var dfvc=new Data.FormValidator.check(frmObj,profile,defaults);return dfvc};Data.FormValidator.check=function(frmObj,profile,defaults){var dfv=new Data.FormValidator();this.frmObj=frmObj;if(typeof(profile)=="string"){alert("TOOD: UNSUPPORTED PROFILE TYPE 'string'");return false}else{this.profile=profile}var results=new Data.FormValidator.Results(profile,frmObj);return results};Data.FormValidator.check_and_report=function(frmObj,profile,goodColor,badColor){goodColor=goodColor||"#FFFFFF";badColor=badColor||"#FFFF99";var results=Data.FormValidator.check(frmObj,profile);results.cleanForm(frmObj,goodColor);if(!results.success()){var error_text="";var msgs=results.msgs();for(field in results.missing_required){results.changeStyle(frmObj,field,badColor);error_text+="Field ["+field+"] is required.\n"}for(field in results.missing_dependency){for(i in results.missing_dependency[field]){var dep=results.missing_dependency[field][i];results.changeStyle(frmObj,dep,badColor);error_text+="Marking field ["+field+"] requires field ["+dep+"] also be filled in.\n"}}for(group in results.missing_depgroup){var completed=results.missing_depgroup[group]['completed'];var incomplete=results.missing_depgroup[group]['incomplete'];for(i in incomplete){results.changeStyle(frmObj,incomplete[i],badColor)}error_text+="Marking field(s) ["+completed.join(', ')+"] requires field(s) ["+incomplete.join(', ')+"] also be filled in.\n"}for(field in results.invalid){results.changeStyle(frmObj,field,badColor);error_text+=(msgs[field])?"Field ["+field+"] : "+msgs[field]:"Improperly formatted data in field ["+field+"].";error_text+="\n"}alert("There is a problem with your form.\n\n"+error_text);return false}else{return true}};Data.FormValidator.prototype.load_profiles=function(){};Data.FormValidator.prototype._mergeProfiles=function(defaults,profile){};Data.FormValidator.prototype._check_profile_syntax=function(profile){};Data.FormValidator.Results=function(profile,frmObject){this.profile=profile;this.constraints=new Data.FormValidator.Constraints();this._process(profile,frmObject)};Data.FormValidator.Results.prototype.success=function(){return!(this.has_invalid()||this.has_missing())};Data.FormValidator.Results.prototype.has_missing=function(){var count=0;for(i in this.missing){count++}return count};Data.FormValidator.Results.prototype.has_invalid=function(){var count=0;for(i in this.invalid){count++}return count};Data.FormValidator.Results.prototype.has_unknown=function(){var count=0;for(i in this.unknown){count++}return count};Data.FormValidator.Results.prototype.has_missing_required=function(){var count=0;for(i in this.missing_required){count++}return count};Data.FormValidator.Results.prototype.has_missing_dependency=function(){var count=0;for(i in this.missing_dependency){count++}return count};Data.FormValidator.Results.prototype.has_missing_depgroup=function(){var count=0;for(i in this.missing_depgroup){count++}return count};Data.FormValidator.Results.prototype._process=function(profile,frmObj){this.valid=new Object();this.invalid=new Object();this.validate_invalid=new Array();this.missing=new Object();this.unknown=new Object();this.missing_required=new Object();this.missing_dependency=new Object();this.missing_depgroup=new Object();this.regexp_test=new RegExp();this.regexp_test.compile('^/(.*)/(g|i|gi|ig)?$');this.required=new Object();this.optional=new Object();if(this.isArray(profile.required)){for(i in profile.required){this.required[profile.required[i]]=1}}if(this.isArray(profile.optional)){for(i in profile.optional){this.optional[profile.optional[i]]=1}}if(this.isArray(profile.required)){for(i in profile.required){if(this.emptyField(frmObj,profile.required[i])){this.missing[profile.required[i]]=1;this.missing_required[profile.required[i]]=1}}}if((typeof(profile.dependencies)=="object")&&(!this.isArray(profile.dependencies))){for(fieldName in profile.dependencies){if(!this.emptyField(frmObj,fieldName)){if(this.isArray(profile.dependencies[fieldName])){for(i in profile.dependencies[fieldName]){var dep=profile.dependencies[fieldName][i];if(this.emptyField(frmObj,dep)){this.missing[dep]=1;if(!this.isArray(this.missing_dependency[fieldName])){this.missing_dependency[fieldName]=new Array()}this.missing_dependency[fieldName][this.missing_dependency[fieldName].length]=dep}}}}}}if((typeof(profile.dependency_groups)=="object")&&(!this.isArray(profile.dependency_groups))){for(group in profile.dependency_groups){if(this.isArray(profile.dependency_groups[group])){var require_all=false;var completed=new Array();var incomplete=new Array();for(i in profile.dependency_groups[group]){var fieldName=profile.dependency_groups[group][i];if(!this.emptyField(frmObj,fieldName)){require_all=true;completed[completed.length]=fieldName}}if(require_all){var missed_depgroup=false;for(i in profile.dependency_groups[group]){var fieldName=profile.dependency_groups[group][i];if(this.emptyField(frmObj,fieldName)){this.missing[fieldName]=1;incomplete[incomplete.length]=fieldName;missed_depgroup=true}}if(missed_depgroup){this.missing_depgroup[group]=new Object();this.missing_depgroup[group]['completed']=completed;this.missing_depgroup[group]['incomplete']=incomplete}}}}}if((typeof(profile.constraints)=="object")&&(!this.isArray(profile.constraints))){for(fieldName in profile.constraints){if((!this.required[fieldName])&&(!this.optional[fieldName])){continue}if(!this.emptyField(frmObj,fieldName)){var checks;if(this.isArray(profile.constraints[fieldName])){checks=profile.constraints[fieldName]}else if((typeof(profile.constraints[fieldName])=="object")||(typeof(profile.constraints[fieldName])=="string")){checks=new Array();checks[0]=profile.constraints[fieldName]}else{continue}for(i in checks){var check=checks[i];var c=new Object();c.name=check;c.constraint=check;if((typeof(check)=="object")&&(!this.isArray(check))){c.constraint=check.constraint_method||check.constraint;c.name=check.name;c.params=check.params;c.is_method=(check.constraint_method)?1:0}var failedTest=false;var re_parts;if(re_parts=this.regexp_test.exec(c.constraint)){var constraint=new RegExp(re_parts[1],re_parts[2]);var fieldValues=this.getField(frmObj,fieldName);for(var x=0;x<fieldValues.length;x++){if(!constraint.test(fieldValues[x])){failedTest=true}}}else if(this.constraints.supported(c.constraint)||this.constraints.supported('valid_'+c.constraint)||this.constraints.supported('match_'+c.constraint)){var constraint=this.constraints.supported(c.constraint)?c.constraint:this.constraints.supported("valid_"+c.constraint)?"valid_"+c.constraint:this.constraints.supported("match_"+c.constraint)?"match_"+c.constraint:"unknown";var fieldValues=this.getField(frmObj,fieldName);for(var x=0;x<fieldValues.length;x++){if(!this.constraints[constraint](fieldValues[x])){failedTest=true}}}else{failedTest=false}if(failedTest){if(!this.isArray(this.invalid[fieldName])){this.invalid[fieldName]=new Array()}this.invalid[fieldName][this.invalid[fieldName].length]=c.name}}}}}for(fieldName in this.invalid){if(this.isArray(this.invalid[fieldName])){var tempArray=new Array();tempArray[0]=fieldName;for(i in this.invalid[fieldName]){tempArray[tempArray.length]=this.invalid[fieldName][i]}this.validate_invalid[this.validate_invalid.length]=tempArray}}for(fieldName in this.required){if((!this.missing[fieldName])&&(!this.invalid[fieldName])){this.valid[fieldName]=1}}for(fieldName in this.optional){if((!this.missing[fieldName])&&(!this.invalid[fieldName])){this.valid[fieldName]=1}}};Data.FormValidator.Constraints=function(){this.state_list=" AL AK AZ AR CA CO CT DE FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA PR RI SC SD TN TX UT VT VA WA WV WI WY DC AP FP FPO APO GU VI ";this.province_list=" AB BC MB NB NF NL NS NT NU ON PE QC SK YT YK "};Data.FormValidator.Constraints.prototype.supported=function(val){var t=new Array();t['match_email']=1;t['match_state_or_province']=1;t['match_state']=1;t['match_province']=1;t['match_zip_or_postcode']=1;t['match_postcode']=1;t['match_zip']=1;t['match_phone']=1;t['match_american_phone']=1;t['match_cc_number']=1;t['match_cc_exp']=1;t['match_cc_type']=1;t['match_ip_address']=1;return t[val]?true:false};Data.FormValidator.Constraints.prototype.constraint_match_re=function(val,re,re_opt){var re=new RegExp(re,re_opt);var re_parts;if(re_parts=re.exec(val)){return re_parts[1]}else{return false}};Data.FormValidator.Constraints.prototype.match_email=function(val){return this.constraint_match_re(val,'^(([a-z0-9_\\.\\+\\-\\=\\?\\^\\#]){1,64}\\@(([a-z0-9\\-]){1,251}\\.){1,252}[a-z0-9]{2,4})$','i')};Data.FormValidator.Constraints.prototype.match_postcode=function(val){return this.constraint_match_re(val,'^([ABCEGHJKLMNPRSTVXYabceghjklmnprstvxy][_\\W]*\\d[_\\W]*[A-Za-z][_\\W]*[- ]?[_\\W]*\\d[_\\W]*[A-Za-z][_\\W]*\\d[_\\W]*)$')};Data.FormValidator.Constraints.prototype.match_zip=function(val){return this.constraint_match_re(val,'^\\s*(\\d{5}(\\-\\d{4})?)\\s*$')};Data.FormValidator.Constraints.prototype.match_phone=function(val){return this.constraint_match_re(val,'^((\\D*\\d\\D*){6,})$')};Data.FormValidator.Constraints.prototype.match_american_phone=function(val){return this.constraint_match_re(val,'^((\\D*\\d\\D*){7,})$')};Data.FormValidator.Constraints.prototype.match_state=function(val){var uc_val=val.toUpperCase();if(this.state_list.indexOf(" "+uc_val+" ")==-1){return false}else{return uc_val}};Data.FormValidator.Constraints.prototype.match_province=function(val){var uc_val=val.toUpperCase();if(this.province_list.indexOf(" "+uc_val+" ")==-1){return false}else{return uc_val}};Data.FormValidator.Constraints.prototype.match_state_or_province=function(val){var match;if(match=this.match_state(val)){return match}if(match=this.match_province(val)){return match}return false};Data.FormValidator.Constraints.prototype.match_zip_or_postcode=function(val){var match;if(match=this.match_zip(val)){return match}if(match=this.match_postcode(val)){return match}return false};Data.FormValidator.Constraints.prototype.match_cc_number=function(the_card,card_type){card_type='visa';card_type=card_type||"UNKNOWN";var card_type_abbr=card_type.toLowerCase().charAt(0);var card_re=/\D/gi;var new_card=the_card.toString().replace(card_re,'');if(new_card.length==0)return false;var card_type_re=/^[admv]/i;if(!card_type_re.test(card_type_abbr))return false;if((card_type_abbr=='v'&&new_card.substr(0,1)!='4')||(card_type_abbr=='m'&&new_card.substr(0,1)!='5')||(card_type_abbr=='d'&&new_card.substr(0,4)!='6011')||(card_type_abbr=='a'&&new_card.substr(0,2)!='34'&&new_card.substr(0,2)!='37')){return false}var card_first_digit=new_card.charAt(0);var card_length=new_card.length;if((card_first_digit=='3'&&card_length!=15)||(card_first_digit=='4'&&card_length!=13&&card_length!=16)||(card_first_digit=='5'&&card_length!=16)||(card_first_digit=='6'&&card_length!=14&&card_length!=16)){return false}var the_sum=0;var multiplier=2;for(var i=(card_length-2);i>=0;i--){var digit=parseInt(new_card.charAt(i),10);var product=multiplier*digit;the_sum+=(product>9)?product-9:product;multiplier=3-multiplier}the_sum%=10;if(the_sum)the_sum=10-the_sum;if(the_sum==new_card.charAt(card_length-1)){var final_re=/^([\d\s]*)$/;var re_parts;if(re_parts=final_re.exec(the_card)){return re_parts[1]}else{return false}}else{return false}};Data.FormValidator.Constraints.prototype.match_cc_exp=function(val){var matched_month;var matched_year;var re=new RegExp('^(\\d+)/(\\d+)$');var re_parts;if(re_parts=re.exec(val)){matched_month=parseInt(re_parts[1],10);matched_year=parseInt(re_parts[2],10)}else{return false}if(matched_month<1||matched_month>12)return false;if(matched_year<1900){matched_year+=(matched_year<70)?2000:1900}var now=new Date();var nowMonth=now.getMonth();var nowYear=now.getYear();if(nowYear.toString().length<4){nowYear+=1900}if((matched_year<nowYear)||(matched_year==nowYear&&matched_month<=nowMonth)){return false}return""+matched_month+"/"+matched_year};Data.FormValidator.Constraints.prototype.match_cc_type=function(val){return this.constraint_match_re(val,'^([admv])','i')};Data.FormValidator.Constraints.prototype.match_ip_address=function(val){var ip=this.constraint_match_re(val,'^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})$');if(!ip)return false;var quad=ip.split('.',4);for(var i=0;i<4;i++){if(quad[i]<0||quad[i]>255)return false}return ip};Data.FormValidator.Results.prototype.msgs=function(controls){var profile=new Object();profile.prefix='';profile.missing='Missing';profile.invalid='Invalid';profile.invalid_separator=' ';profile.format='<span style="color:red;font-weight:bold"><span class="dfv_errors">* %s</span></span>';profile.constraints=new Object();if((typeof(this.profile.msgs)=="object")&&(!this.isArray(this.profile.msgs))){for(key in this.profile.msgs){profile[key]=this.profile.msgs[key]}}var msgs=new Object();if(this.has_invalid()){for(field in this.invalid){var invalidTests=new Array();for(i in this.invalid[field]){var invalidName=this.invalid[field][i];var err_msg=profile.constraints[invalidName]||profile.invalid;invalidTests[invalidTests.length]=err_msg}msgs[field]=invalidTests.join(profile.invalid_separator)}}if(this.has_missing()){for(field in this.missing){msgs[field]=profile.missing}}return msgs};Data.FormValidator.Results.prototype.changeStyle=function(frmObj,fieldName,badColor){var fieldList=this.getElementListByName(frmObj,fieldName);if(!this.isArray(fieldList)){return false}if(!badColor.length){badColor="#FFFF99"}for(var i=0;i<fieldList.length;i++){var type=this.fieldType(fieldList[i]);if(type=="radio"){}else if(type=="button"||type=="reset"||type=="submit"){}else{if(fieldList[i].length){var fieldObj=fieldList[i];if(type.substr(0,6)=="select"){fieldObj.style.backgroundColor=badColor}for(var i=0;i<fieldObj.length;i++){fieldObj[i].style.backgroundColor=badColor}}else{fieldList[i].style.backgroundColor=badColor}}}return true};Data.FormValidator.Results.prototype.cleanForm=function(frmObj,goodColor){if(!goodColor.length){goodColor="#FFFFFF"}var el,e=0;while(el=frmObj.elements[e++]){var type=this.fieldType(el);if(type!="radio"&&type!="button"&&type!="reset"&&type!="submit"){if(el.length){if(type.substr(0,6)=="select"){el.style.background=goodColor}for(var i=0;i<el.length;i++){el[i].style.background=goodColor}}else{el.style.background=goodColor}}}};Data.FormValidator.Results.prototype.getElementListByName=function(frmObj,elementName){var elList=new Array();if((!frmObj.length)||(frmObj.length<=0)){return false}var el,e=0;while(el=frmObj.elements[e++]){if(el.name==elementName){elList[elList.length]=el}}return(elList.length>0)?elList:false};Data.FormValidator.Results.prototype.isArray=function(thisObject){return this.isValidObject(thisObject)&&thisObject.constructor==Array};Data.FormValidator.Results.prototype.isValidObject=function(thisObject){if(null==thisObject){return false}else if('undefined'==typeof(thisObject)){return false}else{return true}};Data.FormValidator.Results.prototype.hasSelected=function(selectObj){var allData=new Array();if(selectObj.type.indexOf("multiple")!=-1){for(var a=0;a<selectObj.options.length;a++){var t_value=(a==0)?selectObj.options[a].value:(selectObj.options[a].value.length)?selectObj.options[a].value:selectObj.options[a].text;if(selectObj.options[a].selected&&(!this.blankText(t_value))){allData[allData.length]=t_value}}}else if(selectObj.options.selectedIndex.toString().length>0){var t_index=selectObj.options.selectedIndex;var t_value=(t_index==0)?selectObj.options[t_index].value:(selectObj.options[t_index].value.length)?selectObj.options[t_index].value:selectObj.options[t_index].text;if(!this.blankText(t_value)){allData[allData.length]=t_value}}return(allData.length>0)?allData:false};Data.FormValidator.Results.prototype.hasChecked=function(checkboxObj){return this.hasRadioOrCheckbox(checkboxObj)};Data.FormValidator.Results.prototype.hasRadio=function(radioObj){return this.hasRadioOrCheckbox(radioObj)};Data.FormValidator.Results.prototype.hasRadioOrCheckbox=function(thisObj){var allData=new Array();if(thisObj.checked){allData[allData.length]=thisObj.value}return(allData.length>0)?allData:false};Data.FormValidator.Results.prototype.hasMCEText=function(mceObj){var allData=new Array();var fieldName=mceObj.name;if(typeof tinyMCE=="undefined"){var txtData=this.hasText(mceObj);if(txtData)allData=txtData}else{if((typeof tinyMCE.majorVersion=="undefined")||(typeof tinyMCE.majorVersion!="undefined"&&tinyMCE.majorVersion<2)){tinyMCE.execInstanceCommand(fieldName,'mceFocus')}allData[allData.length]=tinyMCE.getContent()}return(allData.length>0)?allData:false};Data.FormValidator.Results.prototype.hasText=function(textObj){var allData=new Array();allData[allData.length]=textObj.value;return(allData.length>0)?allData:false};Data.FormValidator.Results.prototype.blankText=function(textObj){if(textObj==null){return true}for(var i=0;i<textObj.length;i++){if((textObj.charAt(i)!=' ')&&(textObj.charAt(i)!="\t")&&(textObj.charAt(i)!="\n")&&(textObj.charAt(i)!="\r")){return false}}return true};Data.FormValidator.Results.prototype.fieldType=function(Obj){if(!this.isValidObject(Obj)){return false}var type=Obj.type.toString();if(type.substr(0,4)=="text"){var mce_trigger=Obj?Obj.getAttribute("mce_editable"):"";if(mce_trigger=="true"){type="tinymce"}}return type};Data.FormValidator.Results.prototype.emptyField=function(frmObj,fieldName){var dataList=this.getField(frmObj,fieldName);if(!this.isArray(dataList)){return true}var hasData=false;for(var i=0;i<dataList.length;i++){if(!this.blankText(dataList[i])){hasData=true}}return hasData?false:true};Data.FormValidator.Results.prototype.getField=function(frmObj,fieldName){var returnValue=new Array();var elList=this.getElementListByName(frmObj,fieldName);if(!this.isArray(elList)){return returnValue}var el,e=0;while(el=elList[e++]){var type=this.fieldType(el);var dataList;if((type.substr(0,4)=="text")||(type.substr(0,4)=="pass")||(type=="file")||(type=="hidden")||(type=="reset")||(type=="submit")){dataList=this.hasText(el)}else if(type=="tinymce"){dataList=this.hasMCEText(el)}else if(type.substr(0,6)=="select"){dataList=this.hasSelected(el)}else if(type=="radio"){dataList=this.hasRadio(el)}else if(type=="checkbox"){dataList=this.hasChecked(el)}else{alert("FORM ERROR: element type ["+type+"] not recognized")}if(this.isArray(dataList)){for(var i=0;i<dataList.length;i++){returnValue[returnValue.length]=dataList[i]}}}return returnValue};