package LIMS::DB::ScreenLabTestDetail;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'screen_lab_test_detail',

    columns => [
        screen_id       => { type => 'integer', not_null => 1 },
        lab_section_id  => { type => 'integer', not_null => 1 },
        test_details    => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        screen => {
            class       => 'LIMS::DB::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('screen_lab_test_details');

1;
