#!/usr/bin/env perl

# mod_cgi instance script for FileUploader::FlowData module:

use strict;
use warnings;

use lib (
    '/home/raj/perl5/lib/perl5',
    '/home/raj/apps/FileUploader/lib',
);

use FindBin qw($RealBin);  # load AFTER local::lib Carp or FindBin loads system
use lib $RealBin . '/../../lib'; # HILIS4 lib

#BEGIN { # don't use these with plack
    # Error handlers:
    # $SIG{__WARN__} = sub { require Carp; Carp::cluck(@_) }; # warnings with stack trace to log
    # use CGI::Carp qw(fatalsToBrowser);
    # use CGI::HTMLError trace => 1;
	# use CGI::Carp::DebugScreen;
    # $SIG{__WARN__} = sub { CORE::die(@_) };
    # use Carp::Always;
    # $SIG{ __DIE__ } = sub { Carp::confess( @_ ) };
#}

#==============================================================================
# ErrorHandler's global $SIG{__DIE__} causes problems in File::stat in Perl 5.14
use File::stat (); # solution is to call *before* ErrorHandler:
use FileUploader::ErrorHandler; # or better still - replace with plack middleware
#==============================================================================

use FileUploader::FlowData;
my %args = (
    PARAMS => {
        cfg_file  => '/home/raj/apps/FileUploader/lib/config.pl',
        file_type => 'flow_data',
    },
);
FileUploader::FlowData->new(%args)->run;