package LIMS::DB::Request;

use base qw(LIMS::RDBO);

use Data::Dumper;

my @relationships = (
    authorised_report => {
        class      => 'LIMS::DB::AuthorisedReport',
        column_map => { id => 'id' },
        type       => 'one to one',
    },

    lab_sections => {
        map_class => 'LIMS::DB::RequestLabSectionNote',
        map_from  => 'request',
        map_to    => 'lab_section',
        type      => 'many to many',
    },

    lab_tests => {
        map_class => 'LIMS::DB::RequestLabTestResult',
        map_from  => 'request',
        map_to    => 'lab_test',
        type      => 'many to many',
    },

    request_audit => {
        class      => 'LIMS::DB::RequestAudit',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_authorisation_diagnosis => {
        class                => 'LIMS::DB::RequestAuthorisationDiagnosis',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
    },

    request_consent => {
        class                => 'LIMS::DB::RequestConsent',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_diagnosis_history => {
        class      => 'LIMS::DB::RequestDiagnosisHistory',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_dispatch_log => {
        class      => 'LIMS::DB::RequestDispatchLog',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_error_code => {
        class      => 'LIMS::DB::RequestErrorCode',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_external_ref => {
        class                => 'LIMS::DB::RequestExternalRef',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_general_note => {
        class                => 'LIMS::DB::RequestGeneralNote',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_history => {
        class      => 'LIMS::DB::RequestHistory',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_initial_screen => {
        class                => 'LIMS::DB::RequestInitialScreen',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_lab_test_history => {
        class      => 'LIMS::DB::RequestLabTestHistory',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_lab_tests_status => {
        class      => 'LIMS::DB::RequestLabTestStatus',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_lab_section_foreign_id => {
        class      => 'LIMS::DB::RequestLabSectionForeignID',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_lab_section_note => {
        class      => 'LIMS::DB::RequestLabSectionNote',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_option => {
        class      => 'LIMS::DB::RequestOption',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_phonelog => {
        class      => 'LIMS::DB::RequestPhoneLog',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_print_log => {
        class      => 'LIMS::DB::RequestPrintLog',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_report => { # this is now a view table - read-only
        class                => 'LIMS::DB::RequestReport',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        optional             => 1,
    },

    request_report_detail => {
        class      => 'LIMS::DB::RequestReportDetail',
        column_map => { id => 'request_id' },
        type       => 'one to one',
    },

    request_report_history => {
        class      => 'LIMS::DB::RequestChangeHistory',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_secondary_diagnosis => {
        class                => 'LIMS::DB::RequestSecondaryDiagnosis',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_specimen => {
        class      => 'LIMS::DB::RequestSpecimen',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_status => {
        class      => 'LIMS::DB::RequestStatusView',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_storage => {
        class      => 'LIMS::DB::RequestStorage',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    request_specimen_detail => {
        class      => 'LIMS::DB::RequestSpecimenDetail',
        column_map => { id => 'request_id' },
        type       => 'one to one',
    },

    request_trial => {
        class                => 'LIMS::DB::RequestTrial',
        column_map           => { id => 'request_id' },
        type                 => 'one to one',
        with_column_triggers => '0',
        optional             => 1,
    },

    request_view_log => {
        class      => 'LIMS::DB::RequestViewLog',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },

    results_summary => { # not generated by make_classes.pl ??
        class      => 'LIMS::DB::RequestResultSummary',
        column_map => { id => 'request_id' },
        type       => 'one to many',
    },
);

my $config = __PACKAGE__->lims_config(); # warn Dumper $config;

# add Outreach rels if in use:
if ($config->{settings}->{have_outreach}) {
    my @outreach = (
        outreach_questionnaire_adenopathy => {
            class      => 'LIMS::DB::Outreach::QuestionnaireAdenopathy',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },
        outreach_questionnaire_eq5d => {
            class      => 'LIMS::DB::Outreach::QuestionnaireEQ5D',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
        outreach_questionnaire_pain => {
            class      => 'LIMS::DB::Outreach::QuestionnairePain',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },
        outreach_questionnaire_service => {
            class      => 'LIMS::DB::Outreach::QuestionnaireService',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
        outreach_questionnaire_symptoms => {
            class      => 'LIMS::DB::Outreach::QuestionnaireSymptoms',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
        outreach_request_followup => {
            class      => 'LIMS::DB::Outreach::RequestFollowup',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
        outreach_request_pack_dispatch => {
            class      => 'LIMS::DB::Outreach::RequestPackDispatch',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
        outreach_request_clinic_return => {
            class      => 'LIMS::DB::Outreach::RequestClinicReturn',
            column_map => { id => 'request_id' },
            type       => 'one to one',
        },
#        outreach_questionnaire_treatment => { # discontinued
#            class      => 'LIMS::DB::Outreach::QuestionnaireTreatment',
#            column_map => { id => 'request_id' },
#            type       => 'one to one',
#        },
    );
    push @relationships, $_ for @outreach;
}

#=begin
__PACKAGE__->meta->setup (
    table   => 'requests',

    columns => [
        id                     => { type => 'serial', not_null => 1 },
        request_number         => { type => 'integer', default => '0', not_null => 1 },
        year                   => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        patient_case_id        => { type => 'integer', default => '0', not_null => 1 },
        referrer_department_id => { type => 'integer', default => '0', not_null => 1 },
        status_option_id       => { type => 'integer', default => '1', not_null => 1 },
        created_at             => { type => 'timestamp', not_null => 1 },
        updated_at             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_number', 'year' ],

    foreign_keys => [
        patient_case => {
          class       => 'LIMS::DB::PatientCase',
          key_columns => { patient_case_id => 'id' },
        },

        referrer_department => {
            class       => 'LIMS::DB::ReferrerDepartment',
            key_columns => { referrer_department_id => 'id' },
        },

        status_option => {
            class       => 'LIMS::DB::StatusOption',
            key_columns => { status_option_id => 'id' },
        },
    ],

    relationships => \@relationships,
);
#=cut

#__PACKAGE__->meta->table('requests');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('requests');

1;

__END__
=begin
    relationships => [
        request_specimen => {
            class      => 'LIMS::DB::RequestSpecimen',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },
        specimen => {
            type      => 'many to many',
            map_class => 'LIMS::DB::RequestSpecimen',
        },
        patient => {
            type      => 'many to many',
            map_class => 'LIMS::DB::PatientCase',
        },
        clinician => {
            class     => 'LIMS::DB::Clinician',
            type      => 'one to many',
            column_map => { referrer_code => 'national_code' },
        },
    ],
=cut
