package LIMS::DB::RequestReportDetail;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_report_detail',

    columns => [
        request_id       => { type => 'integer', not_null => 1 },
        morphology       => { type => 'text', length => 65535 },
        clinical_details => { type => 'text', length => 65535 },
        comment          => { type => 'text', length => 65535 },
        status           => {
            type     => 'enum',
            check_in => [ 'new', 'relapse', 'default' ],
            default  => 'default', not_null => 1,
        },
        diagnosis_id     => { type => 'integer',   not_null => 1 },
        updated_at       => { type => 'timestamp', not_null => 1 },
        created_at       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
    relationships => [
        request_specimen_detail => {
            class       => 'LIMS::DB::RequestSpecimenDetail',
            column_map  => { request_id => 'request_id' },
            type        => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('request_report_details');

1;
