package LIMS::DB::Outreach::DefaultAndRange;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'defaults_and_ranges',

    columns => [
        param_id    => { type => 'integer', not_null => 1 },
        lower_limit => { type => 'numeric', precision => 10, scale => 2 },
        upper_limit => { type => 'numeric', precision => 10, scale => 2 },
        default     => { type => 'numeric', precision => 10, scale => 2 },
        lower_flag  => { type => 'numeric', precision => 10, scale => 2 },
        upper_flag  => { type => 'numeric', precision => 10, scale => 3 },
        units       => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'param_id' ],
    
    foreign_keys => [
        param => {
            class       => 'LIMS::DB::Outreach::LabParam',
            key_columns => { param_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('defaults_and_ranges');

1;