package LIMS::DB::LabTestAccreditation;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'lab_test_accreditation',

    columns => [
        lab_test_id         => { type => 'integer', not_null => 1 },
        accreditation_date  => { type => 'date' },
    ],

    primary_key_columns => [ 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_accreditations');

1;
