package LIMS::Controller::Local::Worklist::FishWorksheet; 

use base 'LIMS::Base';

use Moose;
with (
	'LIMS::Controller::Roles::Misc',
	'LIMS::Controller::Roles::User',
	'LIMS::Controller::Roles::DataMap',
);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift;
    
    my @request_ids = $self->query->param('request_id'); 
    
    { # warn Dumper \@request_ids; # check at least 1 submitted:
        my $url = $self->query->url()
            . '/local_worklist?function_name=fish_worksheets';
        return $self->redirect($url) unless @request_ids
    } 

    # get request & report data for request_ids:
    my %args = ( # to use existing method used by Search function
        search_constraints => { id => \@request_ids },
    ); # warn Dumper \%args;
    my $requests = $self->model('Request')->find_requests(\%args);
    $self->tt_params( requests => $requests ); # warn Dumper $requests;
    
    { # specimen map:
		my $specimen_map = $self->specimen_map(\@request_ids);
		$self->tt_params( specimen_map => $specimen_map );
    }
    { # get flow section result summary:
        my @args = (\@request_ids, 'Flow cytometry'); # method accepts list mode args
        my $o = $self->model('LabSection')->get_section_result_summaries(@args);
        # convert to hashref map for tt:
        my %map = map { $_->request_id => $_->results_summary } @$o;
        $self->tt_params( result_summaries => \%map ); # warn Dumper \%map;
    }
    { # get lab-test data from FISH section:
        my %args = (
            section_name => 'FISH',
            request_id   => \@request_ids,
        );
        my $o = $self->model('LabTest')->get_request_lab_tests_for_section(\%args);
        # convert to hashref map for tt:
        my %map = (); # need hash of arrays of objects - 1 request to many tests:
        push @{ $map{$_->request_id} }, $_->lab_test->as_tree for @$o;
        $self->tt_params( fish_data => \%map ); # warn Dumper $fish_tests;
    }
    { # grosss description map:
        my $o = $self->model('Base')->get_objects('RequestGrossDescription', 
            { query => [ request_id => \@request_ids ] } );
        my %data = map { $_->request_id => $_->detail } @$o;
        $self->tt_params( gross_description => \%data );      
    }
    { # get probesets for fish panels:
        # my $cfg = $self->get_yaml_file('fish_worksheets'); # warn Dumper $cfg;
        my $probes = $self->_get_fish_panel_probes(); # warn Dumper $probes;
        $self->tt_params( panel_probes => $probes );
    }
    return $self->render_view('worklist/local/fish/worksheets_wrapper.tt');
}

# ------------------------------------------------------------------------------
sub _get_fish_panel_probes {
    my $self = shift; $self->_debug_path();
    
    my $o = $self->model('LabTest')->get_panel_lab_tests('fish');
    
    # need HoA:
    my %probes = ();
    for (@$o) {
        my $panel_name = $_->panel_test->test_name;
        my $probe_name = $_->lab_test->field_label;
        push @{ $probes{$panel_name} }, $probe_name;
    } # warn Dumper \%probes;
    return \%probes;
}

1;