#!/usr/bin/perl

# just testing for dfv errors using LIMS::Validation profiles:

use Test::WWW::Mechanize::CGIApp;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 27;
# use Test::More 'no_plan';

=begin: tests:
1) phonelog profile
2) request_error profile
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# phonelog profile:
$mech->get_ok('/search/=/1');                                 # print_and_exit();
{
    $mech->follow_link_ok(
        # {n => 8}, "Logout $_ via eighth link on page",
        { url_regex => qr(phone-log), },
        'follow phonelog link',
    );                                                        # print_and_exit();
    
    my %new_log = (
        status  => 'inbound',
        contact => 'Dr. Who',
        summary => 'request report copy',
        user_id => 1,
    );
    
    test_missing_required(\%new_log);                         # print_and_exit();

    $mech->submit_form(fields => \%new_log);                  # print_and_exit();

    lacks_dfv_errors();
    
    my $msg = get_messages('action')->{create_success};
    
    $mech->has_tag_like(
        p => qr($msg),
        'OK: record created successfully',
    );                                                         # print_and_exit();
    
    $mech->has_tag(
        td => 'request report copy',
        'OK: expected text found',
    );
    
    $new_log{status} = 'outbound';
    $new_log{summary} = undef;
    $new_log{comments} = 'Where\'s Rose?'; # optional

    $mech->submit_form(fields => \%new_log);                  # print_and_exit();

    $mech->has_tag_like(
        p => qr($msg),
        'OK: record created successfully',
    );                                                         # print_and_exit();
    
    $mech->has_tag(
        td => 'Where\'s Rose?',
        'OK: expected text found',
    );

    $new_log{status} = 'inbound';
    $new_log{summary} = 'request report copy';
    $new_log{comments} = 'should be new sentence here'; # optional

    $mech->submit_form(fields => \%new_log);                  # print_and_exit();

    $mech->has_tag_like(
        p => qr($msg),
        'OK: record created successfully',
    );                                                        # print_and_exit();
    
    $mech->has_tag(
        td => 'request report copy; should be new sentence here',
        'OK: expected text found',
    );                                                         # print_and_exit();
}

# request_error profile:
$mech->get_ok('/search/=/1');                                  # print_and_exit();
{
    $mech->follow_link_ok(
        # {n => 8}, "Logout $_ via eighth link on page",
        { url_regex => qr(error), },
        'follow error link',
    );                                                        # print_and_exit();
    
    # requires LIC or error_code_id:
   $mech->submit();                                          # print_and_exit();
    
    has_dfv_errors();
    has_missing();
    
    $mech->field(error_code_id => 1);
    $mech->submit();                                          # print_and_exit();
    
    lacks_dfv_errors();
    lacks_missing();    
}
