package LIMS::DB::ScreenLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'screen_lab_test',

    columns => [
        screen_id   => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        screen => {
            class       => 'LIMS::DB::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('screen_lab_tests');

1;
