package LIMS::DB::RequestSpecimenDetail;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_specimen_detail',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        gross_description  => { type => 'text', length => 65535, not_null => 1 },
        biopsy_site        => { type => 'text', length => 65535, not_null => 1 },
        specimen_quality => {
            type     => 'enum',
            check_in => [ 'good', 'adequate', 'poor' ],
        },
        specimen_date      => { type => 'datetime' },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
    relationships => [
        request_report_detail => {
            class       => 'LIMS::DB::RequestReportDetail',
            column_map  => { request_id => 'request_id' },
            type        => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('request_specimen_details');

1;
