#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
# use HTML::TreeBuilder;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 23; # use Test::More 'no_plan';

=begin # tests:
1) submit new error code
2) submit another new error code
3) submit new test with duplicate error code
4) change duplicate code to unique & submit
5) test for presence of all 3 error code entries
6) change 1st error code to another unique value
7) inactivate one error code
8) retrieve record and change error code to one in use - skipped (fatal) - tested in ajax.t
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to drop & re-create following tables:
foreach ( qw/error_codes/ ) {
    drop_and_recreate($_);
}

$mech->get_ok('/config/error-codes');                         # print_and_exit();

### check title:
$mech->content_contains(
    'Admin &raquo; Error Codes',
    'title matches',
);                                                            # print_and_exit();

# add 2 error_codes:
{
    my %fields = (
        description => 'data entry error',
        is_unique   => 'yes',
        code        => 'A', # enter uppercase so content_contains doesn't need uc 
    );
    
    $mech->submit_form(fields => \%fields);                   # print_and_exit();
    
    ### check values found:
    $mech->content_contains(
        qq!<strong>$fields{code}</strong>!,
        'new error code value correct',
    );                                    
    $mech->content_contains(
        qq!value="$fields{description}"!,
        'new error code description correct',
    );                                    
    
}                                                             # print_and_exit();

{
    my %fields = (
        description => 'reporting error',
        is_unique   => 'yes',
        code        => 'B', # enter uppercase so content_contains doesn't need uc 
    );
    
    $mech->submit_form(fields => \%fields);                   # print_and_exit();
    
    ### check values found:
    $mech->content_contains(
        qq!<strong>$fields{code}</strong>!,
        'new error code value correct',
    );                                    
    $mech->content_contains(
        qq!value="$fields{description}"!,
        'new error code description correct',
    );                                    
    
}                                                             # print_and_exit();

# try duplicate code:
{
    my %fields = (
        description => 'analytical error',
        code => 'B', # enter uppercase so content_contains doesn't need uc 
    );
    
    $mech->submit_form(fields => \%fields);                  # print_and_exit();
    has_duplicate();
    
    $mech->back();
    
    # change to unique code:
    $fields{code} = 'C';
    $mech->submit_form(fields => \%fields);                  # print_and_exit();
}                                            

# check all 3 error_codes detected:
{
    foreach ('data entry', 'reporting', 'analytical')  {
        ### check values found:
        $mech->content_contains(
            qq!value="$_ error"!,
            'OK: expected error code description detected',
        );
    }
}

# edit 1st entry:
$mech->get_ok('/config/error-codes/edit/1');                  # print_and_exit();

{    
    ### check values found:
    $mech->content_contains(
        qq!value="A"!,
        'OK: expected error code detected',
    );

    my $old_code = 'A';
    my $new_code = 'D';
    
    $mech->field('code',$new_code);
    $mech->submit_form();                                     # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!<strong>$new_code</strong>!,
        'new entry value correct',
    );                                                        # print_and_exit();  

    ### check section found:
    $mech->content_lacks(
        qq!<strong>$old_code</strong>!,
        'previous entry value not detected',
    );                                                        # print_and_exit(); 
}

# inactivate 1st entry:
{
    # 1st check for absence of inactive record:
    $mech->content_lacks(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                                        # print_and_exit();  

    # select 2nd 'Edit' link:
    $mech->follow_link(text => 'Edit', n => 2 );              # print_and_exit();
    
    # check for correct entry:
    $mech->content_contains(
        qq!value="analytical error"!,
        'OK: correct entry loaded',
    );                                                        # print_and_exit();
    
    $mech->field('active', 'No');
    $mech->submit_form();                                     # print_and_exit();

    # now check for presence of inactive flag (not specific to this records, but there's only 2):
    $mech->content_contains(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                                        # print_and_exit();  
}

# try to edit entry to re-use error_code:
{    
    # select 1st 'Edit' link:
    $mech->follow_link(text => 'Edit', n => 1 );              # print_and_exit();
    
    # check for correct entry:
    $mech->content_contains(
        qq!value="reporting error"!,
        'OK: correct entry loaded',
    );                                                        # print_and_exit();
    SKIP: {
        skip('generates DBI error - duplicate entry on edit tested in 05ajax.t', 1);

        my $duplicate_field = 'D';
    
        $mech->field('code', $duplicate_field);
        $mech->submit_form();                                 # print_and_exit();
    
        # check error return from DBI:
        $mech->content_contains(
            qq!Duplicate entry '$duplicate_field'!,
            'OK: duplicate value detected',
        );
    
        $mech->back();
    }
}

# do_logout(); logout link not available for admin function