package LIMS::DB::RequestReportHistory;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_report_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        field      => {
            type     => 'enum',
            check_in => [ 'comment', 'morphology' ],
        },        
        content    => { type => 'text', length => 65535 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
    
    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_report_histories');

1;