package LIMS::DB::ErrorCode;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'error_codes',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        is_unique	=> { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        active	    => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],

    relationships => [
        patient_edit => {
            class      => 'LIMS::DB::PatientEdit',
            column_map => { id => 'error_code_id' },
            type       => 'one to many',
        },

        report_error_code => {
            class                => 'LIMS::DB::ReportErrorCode',
            column_map           => { code => 'code' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_error_code => {
            class      => 'LIMS::DB::RequestErrorCode',
            column_map => { id => 'error_code_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('error_codes');

1;
