package LIMS::Controller::Admin::Lab::Test::Linked;

use base 'LIMS::Base';
use LIMS::Local::Sugar;
use Data::Dumper;

use Moose;
with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);

    my $vars = $self->query->Vars; # warn Dumper $vars;
    $self->tt_params( vars => $vars );

    { # get lab sections:
        my $sections = $self->model('LabSection')->get_lab_sections();
        $self->tt_params( sections => $sections );
    }
    { # get current linked lab-tests:
        my @joins = (
			'parent_lab_test.lab_section',
			'linked_lab_test.lab_section',
		);
		my $args = { sort_by => 'parent_lab_test.field_label' };
        my @args = ( 'LinkedLabTest', $args, \@joins );
        my $linked_tests = $self->model('Base')->get_objects(@args);
        $self->tt_params( all_linked_tests => $linked_tests ); # warn Dumper $linked_tests;

        { # hashmap of existing parent -> linked test entries:
            my %map = (); # map +($_->parent_test_id => 1), @$linked_tests;
            push @{ $map{$_->parent_test_id} }, $_->linked_test_id
                for @$linked_tests; # warn Dumper \%map;
            $self->stash( linked_tests_map => \%map ); # for all lab-tests & sections block
            $self->tt_params( linked_tests_map => \%map );
        }
    }
    # get lab tests for selected section if submitted:
    if ( my $lab_section_id = $vars->{lab_section_id} ) {
        my %args = ( lab_section_id => $lab_section_id );
        my $lab_tests = $self->model('LabTest')->get_section_lab_tests(\%args);
        $self->tt_params( parent_tests => $lab_tests );
    }
    # get all lab tests if parent_lab_test submitted:
    if ( my $parent_test_id = $vars->{parent_test_id} ) { # get all lab tests & sections:
        my $tests = $self->model('LabTest')->get_all_active_lab_tests; # iterator

        my $linked_test_ids = $self->stash->{linked_tests_map}->{$parent_test_id};
        my %lab_tests; # warn Dumper $linked_test_ids;
        while ( my $test = $tests->next ) { # DEBUG $test->lab_section->section_name;
            my $lab_section = $test->lab_section->section_name;
            my $test_data   = $test->as_tree;
            # if the test.id matches a linked_test_id, set field to 'selected' for template:
            if ( grep { $test->id == $_ } @$linked_test_ids ) {
                $test_data->{selected} = 1;
            }
            push @{ $lab_tests{ $lab_section } }, $test_data;
        }
        $self->tt_params( lab_tests => \%lab_tests ); # warn Dumper \%lab_tests;
    }
=begin # getting all lab-tests now - don't need this section
    if ( my $linked_lab_section_id = $vars->{linked_lab_section_id} ) {
        my $linked_lab_section_tests; # get tests for section if different:
        if ( $linked_lab_section_id == $vars->{lab_section_id} ) { # same section
            $linked_lab_section_tests = $self->stash->{parent_lab_tests};
        }
        else { # get tests for different section
            my %args = ( lab_section_id => $linked_lab_section_id );
            $linked_lab_section_tests
                = $self->model('LabTest')->get_section_lab_tests(\%args);
        }
        $self->tt_params( linked_lab_section_tests => $linked_lab_section_tests );
    }
=cut
   	return $self->tt_process;
}

runmode do_link {
    $self->_debug_path($self->get_current_runmode);

    my $parent_lab_test_id = $self->param('id')
        || return $self->error('no id passed to ' . $self->get_current_runmode);
    my @linked_lab_test_id = $self->query->param('test_id'); # can be list or empty

    my %data = (
        parent_test_id => $parent_lab_test_id,
        linked_test_id => \@linked_lab_test_id,
    ); # warn Dumper \%data;

    my $rtn = $self->model('LabTest')->update_linked_lab_tests(\%data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{create_success} );
		return $self->redirect( $self->query->url . '/admin/lab_test_linked' ); # safer to redirect after db edit
	}
}

1;
