#!/usr/bin/perl

# called as $self->messages('foo')->{bar}

{
    msg => {
		
# used in templates & test suite to flag general validation failure:
		dfv_errors => 'Error - form validation failed:', 
# used by templates to indicate validation failure on multiple fields:
		require_one => 'require at least one of the empty fields highlighted',
        
#-------------------------------------------------------------------------------
# messages used by LIMS::Validate & Controller::Ajax to flag specific validation
# failures - displayed in template using format specified in dfv_defaults.msgs.format
# in config:
		dfv_msgs => {
			alphanumeric  => 'only alpha-numeric characters [a-z & 0-9] allowed',
			future_date   => 'invalid - date is in future',
			invalid_date  => 'invalid date',
			date_order    => 'check chronological order',
			invalid_entry => 'invalid', # used by Ajax controller only
			need_integer  => 'invalid format - numbers only required',
            no_spaces     => 'invalid format - no spaces allowed',
			not_unique    => 'entry already exists',
			numbers_only  => 'numeric format [0-9] required',
			single_word   => 'require single word, or words separated by underscore(s)',
			too_high 	  => 'exceeds maximum value',
			too_long	  => 'invalid format - too many characters',
			referrer_code => 'require C, D, E or CS, followed by 5-7 numbers',
			year_digits   => 'require 4-digit year',
			report_confirm => "require either 'revision' or 'final diagnosis' fields",
			invalid_domain => 'invalid email address (domain not allowed)',
        },

# messages used by FormValidator::Simple only:
        form_validator => {
            user => {
                pwds => {
                    DUPLICATION => 'your new password fields did not match, please try again',
                },
                old_password => {
                    LENGTH    => 'old password - length should be minimun 5 chars',
                    NOT_BLANK => 'old password - cannot be blank',
                },
                new_password => {
                    LENGTH    => 'new password - length should be minimun 5 chars',
                    NOT_BLANK => 'new password - cannot be blank',
                },
                new_password_confirm => {
                    LENGTH    => 'confirm new password - length should be minimun 5 chars',
                    NOT_BLANK => 'confirm new  password - cannot be blank',
                },
            },

            patient_data => {

            },

            settings => {
                admin_contact => {
                    NOT_BLANK   => 'admin contact - cannot be blank',
                    EMAIL_LOOSE => 'does not appear to be valid e-mail address',
                },
                admin_timeout => {
                    NOT_BLANK => 'admin timeout field - cannot be blank',
                    INT       => 'must be valid integer (0 to disable)',
                },
                internal_user_timeout => {
                    NOT_BLANK => 'internal user timeout field - cannot be blank',
                    INT       => 'must be valid integer (0 to disable)',
                },
                external_user_timeout => {
                    NOT_BLANK => 'external user timeout field - cannot be blank',
                    INT       => 'must be valid integer (0 to disable)',
                },
            },
        },
		
# messages used by controllers via stash/flash/error/die:
# $self->messages('foo')->{bar}
#-------------------------------------------------------------------------------
        # general success messages for record update/create/edit/delete:
		action => {
			create_success => 'new record created successfully',
			edit_success   => 'record updated successfully',
			delete_success => 'record deleted successfully',
		},
		# admin/config messages:
		admin => {
            no_sections
                => 'no lab sections defined yet - please enter at least one before assigning lab tests',
            no_screens
                => 'no screening terms defined yet - please enter at least one before assigning lab tests',
            no_tests
                => 'no lab tests defined yet - please enter at least one before assigning screen tests',
            no_groups
                => 'no user groups defined yet - please enter at least one before assigning group functions',
            no_functions
                => 'no user functions defined yet - please enter at least one before assigning group functions',
            no_diagnostic_categories
                => 'no diagnostic categories defined yet - please enter at least one before defining diagnoses',
            no_request_audit_categories
                => 'no request audit categories defined yet - please enter at least one before defining options',
            settings => {
                update_successful => 'application settings change successful',
                require_restart => 'you will need to re-start the Apache server for changes to take effect',
            },
			data_file => {
				prefix_error => 'file address needs to be complete - did you forget http(s):// ?',
				url_error => 'file address empty or file type incorrect (ie zip or csv)',
				not_csv => 'zip file did not contain a csv file',
				unrecognised => 'zip contents or uploaded filename "%s" is not a recognised filename',
				update_success => 'new data file upload successful',
				update_failed => 'data file upload and/or data file update failed',
			},
			error_code => {
				not_unique => 'error code %s already exists',
				config_update => 'error codes updated successfully',
			},
			clinician => {
				not_unique => 'combination of clinician code & location already exists',
				name_mismatch => 'surname mis-match with existing record for %s [%s]',
				create_success => 'new clinician entry successful',
				edit_success => 'referrer details updated successfully',
				failure => 'failed to create new clinician',
			},
			user => {
				edit_success => 'user details updated successfully',
				create_success => 'new user created successfully',
			},
            referral_source => {
                outreach => 'check post-code area in blood_tube.yml config file if adding new Outreach practice',
            },
        },
		demographics => {
			pas_insufficient_info => 'Insufficient information to perform PAS search',
			pas_no_matches => 'No PAS matches',
			pas_verified => 'Patient demographics verified',
			pas_timeout => 'PAS server timeout - please try again',
			pas_insufficient_vars => 'Require at least 2 fields to perform PAS search',
		},
		file_upload => {
			unsuitable_filetype => 'file is not a zip or xls file',
			bcr_abl => {
				poor_quality => {
					summary => 'ABL copy number < 10000',
					result  => 'unsuitable for RQ-PCR analysis, ABL copy number < 10000',
				},
			}
		},
        group_functions => {
            empty_functions_list => 'all functions have been cleared',
        },
        login => {
            enter_details => 'Please enter your login details:',
            already_logged_in => q!You are already logged in as '%s'!,
            login_failed => 'Username and/or password not recognised',
            logged_out => q!You have now logged out. For security reasons, please
				remember to close your browser.!, # can't - session deleted so it's lost
            email_not_found => 'Sorry, e-mail address not recognised',
            session_id_not_found => 'error recovering your data, please login manually',
            missing_attribute => 'missing "%s" attribute in configuration settings',
        },
        outreach => {
            alternate => 'both address and post-code required for alternate address section',
            missing_dates => 'have either missing or invalid dates',
            questionnaire_success => 'questionnaire data entered successfully',
        },
		patient => {
			merge => {
				not_flagged => q!either no records were selected from col. A (from),
					or >1 record was selected in col. B (to)!,
				too_many => 'too many records found (%s) - you might want to refine your search',
				merge_success => 'patients merged successfully'
			},
		},
        registration => {
			empty_submission => 'Please enter something to search for and try again.',
            invalid_select => 'Sorry, your selection was invalid. I\'ve no idea why. Please try again.',
            confirmation_required => 'Confimation required before records can be updated',
            form_validated => 'Patient details validated, OK to submit',
            no_records_found => 'Found 0 records matching %s',
			cannot_delete_case => 'Patient case belongs to 1 or more requests - cannot be deleted',
			cannot_delete_patient => 'Patient has other requests - cannot be deleted',
        },
		request_edit => {
			edit_failed    => 'record not updated - perhaps there were no changes?',
			edit_success   => '%s record(s) updated successfully',
			unlock_success => 'record unlocked',
			delete_success => 'record deleted',
		},
		results => {
			update_success => 'results data update successful',
			no_data_file   => 'appear to have no valid data file in directory',
			no_userid      => 'unrecognised username in data file',
			xs_data_files  => 'appear to have more than one data file in directory',
			empty_data     => 'cannot extract data from data file',
			empty_acquired => "cannot parse 'date acquired' val from data file",
			empty_result   => 'cannot extract flow data result from data file',
			filename_error => "internal 'filename' field doesn't match data file name",
			surname_error  => "internal 'surname' field doesn't match patient surname",
			dob_error	   => "internal 'dob' field doesn't match patient dob",
		},
		report => {
			revision_missing  => 'revision data is required if diagnosis is changed',
			not_screened      => 'cannot report an unscreened record',
			not_reported      => 'cannot authorise an unreported record',
			no_self_auth      => 'authorisation by original reporter not permitted',
			no_auth_diagnosis => 'failed to log authorisation audit - don\'t know why',
			email_success     => 'mail server reports message was sent to %s successfully',
			email_failure     => 'mail server reports "%s"',
		},
		search => {
			empty_submission => 'Please enter something to search for and try again.',
			no_records_found => 'No matching requests were found',			
			too_many_records => 'Found too many requests to display (%s), please refine search and try again',
		},
        screen => {
            empty_screen_list => 'all tests have been cleared',
        },
        user => {
            pwd_incorrect    => 'password incorrect, please try again',
            old_pwd_mismatch => 'old password incorrect, please try again',
            new_pwd_mismatch => 'your new password fields did not match, please try again',
            pwd_change_success => 'password change successful, please re-login:',
        },
		worklist => {
			no_tests_for_status => 'no outstanding tests with status = %s',
			no_outstanding_tests => 'no outstanding %s tests for %s section',
			no_outstanding_requests => 'no outstanding requests',
			no_lab_test_ids => 'no lab tests data receieved',
			no_request_ids  => 'no records selected for update',
			update_success  => 'records updated successfully',
			update_failure  => 'no records were updated',
			print_labels_ok => 'printer reports labels printed successfully',
		},
		
#-------------------------------------------------------------------------------
        _not_currently_used => {
			invalid_form => 'Validation error',
			missing_data => 'missing data - must complete all sections',			
			no_history => 'Request does not appear to have any previous history', # also used for no id submitted
			duplicate_lab_number => 'lab number already used',
			duplicate_nhs_number => 'NHS number already used',
			search_again => 'Found %s records, please refine search',
		},
    },
}