package LIMS::DB::RequestStatusView;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_status_view',

    columns => [
        request_id       => { type => 'integer', default => '0', not_null => 1 },
        status_option_id => { type => 'integer', default => '0', not_null => 1 },
        time             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'status_option_id' ],
    
    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
        status_option => {
            class       => 'LIMS::DB::StatusOption',
            key_columns => { status_option_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_status');

1;