#!/usr/bin/perl

# reads hilis3 conversion log, checks last line = 'Process ran ...'

use strict;
use warnings;

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib "$Bin/../../../lib";
	use lib '/home/raj/perl5/lib/perl5';
}

use IO::All;
use Data::Dumper;
use File::ReadBackwards; # not used directly but IO::All::tail needs it
use Mail::Sendmail 0.79; # needs authentication functions

my $log_file = '/home/raj/cron/hilis.log';
my $io = io $log_file;

exit unless $io->size; # skip empty file
# get last 2 lines (last line maybe a blank):
my @last_lines = $io->tail(2); # warn Dumper \@last_lines; exit;

alert_admin() if (! grep { $_ =~ /^Process ran/ } @last_lines);

sub alert_admin {
	my %mail = (		
		From 	=> 'hmds.lth@nhs.net',
		To 	    => 'ra.jones@hmds.org.uk',
		Subject => 'HILIS3 CONVERSION FAILED',
		Message => "Last lines:\n@last_lines",
		SMTP    => 'smtp.titaninternet.co.uk',
		Auth    => { 
			method   => 'DIGEST-MD5 LOGIN PLAIN', 
			user     => 'ra.jones@hmds.org.uk', 
			password => 'tetramor',
		},
	); # warn Dumper \%mail;

	sendmail(%mail);
}