package LIMS::Controller::HMRN::Data;

use Moose;
BEGIN { extends 'LIMS::Base'; }
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

__PACKAGE__->authz->authz_runmodes(	':all' => 'view_clinical_data' );

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
sub load : Runmode {
    my $self = shift;

	return $self->forbidden() unless $self->user_can('view_clinical_data');

    my $request_id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);
    
    # get request data:
    my $request_data
        = $self->model('Request')->get_single_request($request_id);
    $self->tt_params( request_data => $request_data );
    
    my $patient_id = $request_data->patient_case->patient_id;

    { # get request history:
        my $history = $self->model('History')->get_request_history($request_id);
        # create hash with keys = action & values = associated history object:
        my %request_history = map { $_->action => $_ } @$history;
        $self->tt_params( request_history => \%request_history );
    }
    { # get patient demographic data:        
        my $demographics
            = $self->model('HMRN')->get_patient_demographics($patient_id);
        $self->tt_params( demographic_data => $demographics );
    }    
    {  # get hmrn data:
        my $hmrn_data = $self->model('HMRN')->get_all_hmrn_data($patient_id);
        
        # is patient also in outreach (can't edit GP practice if so):
        if ($self->cfg('settings')->{have_outreach}) {
            my $in_outreach = $self->model('HMRN')->is_in_outreach($patient_id);
            $hmrn_data->{is_in_outreach} = $in_outreach;
        }
        $self->tt_params( hmrn_data => $hmrn_data );
    }
    
    return $self->tt_process();
}

# ------------------------------------------------------------------------------
sub edit_demographics : Runmode {
    my $self = shift;
    
	return $self->forbidden() unless $self->user_can('enter_clinical_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    my $patient_id = $self->param('Id')
    || return $self->error('no patient_id passed to '.$self->get_current_runmode);
    
    my $vars = $self->query->Vars;
    # add patient_id:
    $vars->{patient_id} = $patient_id;
    
    my $rtn = $self->model('HMRN')->update_patient_demographics($vars);
    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $self->query->url . '/hmrn_data/=/' . $request_id );
}

# ------------------------------------------------------------------------------
sub edit_chronology : Runmode {
    my $self = shift;
    
	return $self->forbidden() unless $self->user_can('enter_clinical_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    my $patient_id = $self->param('Id')
    || return $self->error('no patient_id passed to '.$self->get_current_runmode);

    my $vars = $self->query->Vars;
    
    # add patient_id:
    $vars->{patient_id} = $patient_id;
    
    my $rtn = $self->model('HMRN')->update_patient_chronologies($vars);
    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $self->query->url . '/hmrn_data/=/' . $request_id );    
}

# ------------------------------------------------------------------------------
sub edit_antecedent : Runmode {
    my $self = shift;
    
	return $self->forbidden() unless $self->user_can('enter_clinical_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    my $patient_id = $self->param('Id')
    || return $self->error('no patient_id passed to '.$self->get_current_runmode);

    my $vars = $self->query->Vars;

    # add patient_id:
    $vars->{patient_id} = $patient_id;
    
    my $rtn = $self->model('HMRN')->update_antecedent_events($vars);
    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $self->query->url . '/hmrn_data/=/' . $request_id );    
}

# ------------------------------------------------------------------------------
sub edit_practice : Runmode {
    my $self = shift;
    
	return $self->forbidden() unless $self->user_can('enter_clinical_data');

    my $request_id = $self->param('id')
    || return $self->error('no request_id passed to '.$self->get_current_runmode);
    
    my $patient_id = $self->param('Id')
    || return $self->error('no patient_id passed to '.$self->get_current_runmode);
    
    # if new practice_id submitted:
    if ( my $practice_id = $self->query->param('practice_id') ) {
        my %data = (
            patient_id  => $patient_id,
            practice_id => $practice_id,
        );
        my $rtn = $self->model('HMRN')->update_patient_demographics(\%data);
        return $rtn
            ? $self->error($rtn)
            : $self->redirect( $self->query->url . '/hmrn_data/=/' . $request_id );
    }
    else { # load existing for editing:
        # get current practice_id for patient:
        my $info = $self->model('HMRN')->get_patient_demographics($patient_id);
    
        return $self->tt_process({ data => $info });
    }
}

# ------------------------------------------------------------------------------
# ajax function called from treatment type select menu:
sub treatment_options : Runmode {
	my $self = shift;
	
    my $options = [];
    
    if ( my $tx_type_id = $self->query->param('tx_type_id') ) { # warn $tx_type_id;
    	$options = $self->model('HMRN')->get_tx_details_for_tx_type($tx_type_id);
    }
    
	return $self->tt_process({ options => $options });
}

1;
