use strict;

# just a test script for testing Rose functions

use Rose::DB;
use Rose::DateTime::Util qw(:all);

use Data::Dumper;

Rose::DB->register_db(
  driver   => 'mysql',
  database => 'test',
  username => 'raj',
  password => 'adm1n',
);

#-------------------------------------------------------------------------------
package Foo;

use base qw(Rose::DB::Object);
use Rose::DB::Object::Helpers qw(as_tree);

__PACKAGE__->meta->setup(
  table => 't1',
  columns => [
    id => { type => 'int' },
    ts => { type => 'timestamp' },
	sample_code => { type => 'varchar', length => 4 },
  ],
);

__PACKAGE__->meta->make_manager_class('foo');

1;

#-------------------------------------------------------------------------------
package main;

$Rose::DB::Object::Debug = 1;

my $f = Foo->new(id => 123, ts => parse_date('now'), sample_code => 'this' );
# $DB::single=1; # perl -d script/test_script.pl, c , x $f
$f->save;

my %args = (
    query => [
        # not => [ { id => 123, timestamp => { le => \'NOW' } } ]
        # id => 123,
		sample_code => 'thisistoolong',
    ]
);

my $o = Foo::Manager->get_foo(%args); 
warn Dumper map $_->as_tree, @$o;
# Output:
#
# INSERT INTO t1
# (
#   id,
#   ts
# )
# VALUES
# (
#   ?,
#   ?
# ) - bind params: 123, 2009-05-14 15:26:31
