#!/usr/bin/perl

# just testing for dfv errors using LIMS::Validation profiles:

use Test::WWW::Mechanize::CGIApp;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 53; # use Test::More 'no_plan';

=begin: tests:

=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# initial_screen profile:
$mech->get_ok('/screen/=/1');                               # print_and_exit();
{
    my $cfg = get_config(); # warn Dumper $cfg->{settings};
    my %screen = ( screen_id => 1 );
    
    if ($cfg->{settings}->{have_request_audit}) { # now being forced in test_data.pl
        $screen{option_id} = 1;
    }
    else {
        SKIP: { skip('OK - request audit not in use',2) }
    }
    
    # can't do this now - submitted by j/s function:
    # test_missing_required(\%screen);                           print_and_exit();
    $mech->get_ok('/screen/do_initial_screen/1?screed_id=');    # print_and_exit();
    # check we have dfv error:
    has_dfv_errors();
    has_missing();                                             # print_and_exit();
    
    $mech->get_ok('/screen/do_initial_screen/1?screen_id=1'); #  print_and_exit();
    # check we have dfv error:
    has_dfv_errors();
    # has_missing(); # doesn't show as settings file overrides test_lib settings

    $mech->get_ok('/screen/do_initial_screen/1?screen_id=1;option_id=1'); #  print_and_exit();

    lacks_dfv_errors();
    lacks_missing();
}

# new_request profile #1 (for GP practice):
$mech->get_ok('/request/add_new/1');            # print_and_exit();
{
    my %new_request = (
#        referral_source_id => '', # passed as hidden field   
        referrer_code => 'G1234567',
        request_number => 2, # duplicate
        specimen => 'PBX', # invalid
    );
    
    test_missing_required(\%new_request);               #  print_and_exit();
    
    $mech->submit_form(fields => \%new_request);         #   print_and_exit();
    
    has_dfv_errors();
    has_invalid();
    has_duplicate();                                     # print_and_exit();

    # correct invalid specimen:
    $new_request{specimen} = 'PB';
    $mech->submit_form(fields => \%new_request);           # print_and_exit();
    
    has_dfv_errors();
    lacks_invalid();
    has_duplicate();                                     # print_and_exit();
    
    # correct duplicate lab_number:
    $new_request{request_number}++;

    $mech->submit_form(fields => \%new_request);           # print_and_exit();
    
    lacks_dfv_errors();
    lacks_invalid();
    lacks_duplicate();                                  # print_and_exit();    
}

# new_request profile #2 (for hospital):
$mech->get_ok('/request/add_new/2');                    # print_and_exit();
{
    my %new_request = (
#        referral_source_id => '', # passed as hidden field   
        referrer_code => 'C9999998', # unknown clinician
        request_number => 4, 
        specimen => 'PB, BMAT', 
        trial_number => 'ABC123', # triggers requirement for trial_id
    );

    $mech->submit_form(fields => \%new_request);           # print_and_exit();
    
    has_dfv_errors();
    has_missing();                                      # print_and_exit();
    
    # add missing trial_id:
    $new_request{trial_id} = 1;
    
    $mech->submit_form(fields => \%new_request);           # print_and_exit();

    lacks_dfv_errors();
    lacks_missing();                                 # print_and_exit();            
}

# new_request profile #3 (test various invalid request_number formats):
$mech->get_ok('/request/add_new/2');            # print_and_exit();
{
    my %new_request = (
#        referral_source_id => '', # passed as hidden field   
        referrer_code => 'C9999998', # unknown clinician
        request_number => 300_000, # invalid - fails FV_length_between
        specimen => 'PB', 
    );
    
    $mech->submit_form(fields => \%new_request);           # print_and_exit();
    
    # have invalid field length on request_number:
    has_dfv_errors();
    $mech->content_contains( 
        dfv_format('too_long'),
        'OK: invalid field length detected',
    );                                                       # print_and_exit(); 

    # change request_number to trigger FV_num_int failure:
    $new_request{request_number} = 33.3; # decimal
    $mech->submit_form(fields => \%new_request);            # print_and_exit();

    has_dfv_errors();
    $mech->content_contains( 
        dfv_format('need_integer'),
        'OK: invalid field format detected',
    );                                                # print_and_exit(); 
    
    # invalid by adding prefix:
    $new_request{request_number} = 'H3'; 
    $mech->submit_form(fields => \%new_request);            # print_and_exit();

    has_dfv_errors();
    $mech->content_contains( 
        dfv_format('need_integer'),
        'OK: invalid field format detected',
    );                                              # print_and_exit(); 

    # invalidate by adding year on duplicate request (triggers duplicate AND invalid):
    $new_request{request_number} = '3/09'; 
    $mech->submit_form(fields => \%new_request);            # print_and_exit();

    has_dfv_errors();
    has_duplicate();
    $mech->content_contains( 
        dfv_format('need_integer'),
        'OK: invalid field format detected',
    );                                                    # print_and_exit(); 
    
    # invalidate by adding year on unique request (triggers invalid only):
    $new_request{request_number} = '10/09';
    $mech->submit_form(fields => \%new_request);             # print_and_exit();

    has_dfv_errors();
    lacks_duplicate();
    $mech->content_contains( 
        dfv_format('need_integer'),
        'OK: invalid field format detected',
    );                                                  # print_and_exit(); 
}

# delete record profile:
$mech->get_ok('/request/delete_request/1');    				  # print_and_exit();
{
	my %delete = (
		reason => 'inappropriate request',
		confirm_delete => 1,
	);
	test_missing_required(\%delete);                          # print_and_exit();
    
	$mech->submit_form(fields => \%delete);                   # print_and_exit();
    lacks_dfv_errors();										#	print_and_exit();
}