package LIMS::DB::RequestPhoneLog;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_phone_log',

    columns => [
		id         => { type => 'serial', default => 0, not_null => 1 },
        request_id => { type => 'integer', not_null => 1 },
        user_id    => { type => 'integer', not_null => 1 },
		status     => { type => 'enum', check_in => [ 'inbound', 'outbound' ], not_null => 1 },
		contact    => { type => 'varchar', length => 255, not_null => 1 },
		details    => { type => 'varchar', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 0 },
    ],
	
	primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('request_phone_log');

1;
