package LIMS::DB::Outreach::QuestionnairePain;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_pain',
    
    columns => [
        request_id => { type => 'integer', not_null => 1 },
        rib_pain   => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        back_pain  => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        arm_pain   => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        leg_pain   => { type => 'enum', check_in => [ 'none', 'mild', 'moderate', 'severe' ] },
        persistent_rib_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_back_pain => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_arm_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
        persistent_leg_pain  => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_pain');

1;
