#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
# use HTML::TreeBuilder;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 36; # use Test::More 'no_plan';

=begin tests:
1) 
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to drop & re-create following tables:
foreach ( qw/diagnoses diagnostic_categories/ ) {
    drop_and_recreate($_);
}

$mech->get_ok('/config/diagnoses');        # print_and_exit();

$mech->content_contains(
    get_messages('admin')->{no_diagnostic_categories},
    'error generated due to no diagnostic categories defined',
);

$mech->get_ok('/config/diagnostic-categories');     # print_and_exit();

### check title:
$mech->content_contains(
    'Admin &raquo; Diagnostic Categories',
    'title matches',
);                                     # print_and_exit();

# add 3 terms:
{
    my $description = 'B-lymphoproliferative';
    
    $mech->field('description', $description);
    $mech->submit_form();                    # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$description"!,
        'new entry value correct',
    );                                    # print_and_exit();
}

{
    my $description = 'Myelodysplastic';
    
    $mech->field('description', $description);
    $mech->submit_form();                  # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$description"!,
        'new entry value correct',
    );                                    # print_and_exit(); 
}

{
    my $description = 'T-lymphoproliferative';
    
    $mech->field('description', $description);
    $mech->submit_form();                  # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$description"!,
        'new entry value correct',
    );                                    # print_and_exit();
}

# edit 2nd entry:
$mech->get_ok('/config/diagnostic-categories/edit/2');   # print_and_exit();

{
    my $old_term = 'Myelodysplastic';
    my $new_term = 'Myeloproliferative';
    
    $mech->field('description', $new_term);
    $mech->field('category_type', 'main');
    $mech->submit_form();                                 # print_and_exit();
    
    lacks_dfv_errors();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$new_term"!,
        'new entry value correct',
    );                                                  # print_and_exit();  

    ### check section found:
    $mech->content_lacks(
        qq!value="$old_term"!,
        'previous entry value not detected',
    );                                    # print_and_exit(); 
}

$mech->get_ok('/config/diagnoses');         # print_and_exit();

### check title:
$mech->content_contains(
    'Admin &raquo; Diagnoses',
    'title matches',
);                                     # print_and_exit();

# add new diagnostic terms:

{ # mis-spell name for later correction:
    my $name = 'Mantle cel lymphoma';
    my $icdo3 = '9673/3';
    my $diagnostic_category_id = 1;
    
    $mech->submit_form(
        fields => {
            name => $name,
            icdo3 => $icdo3,
            diagnostic_category_id => $diagnostic_category_id,
        }
    );                                             # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!name="icdo3" value="$icdo3"!,
        'new entry value correct',
    );                                   # print_and_exit();
    $mech->content_contains(
        qq!name="name" value="$name"!,
        'new entry value correct',
    );                                    # print_and_exit();
    $mech->content_contains(
        qq!value="B-lymphoproliferative"!,
        'new entry value correct',
    );                                    # print_and_exit();
}

{
    my $name = 'Systemic mastocytosis';
    my $icdo3 = '9741/3';
    
    # 'forget' to select diagnostic_category:
    $mech->submit_form(
        fields => {
            name => $name,
            icdo3 => $icdo3,
#            diagnostic_category_id => undef, # can't submit empty value !!
        }
    );                                             # print_and_exit();
    
    ### check form validation failed:
    has_dfv_errors();

    # select incorrect diagnostic_category:
    my $diagnostic_category_id = 3;
    
    $mech->field('diagnostic_category_id', $diagnostic_category_id);
    $mech->submit_form();                        # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!name="icdo3" value="$icdo3"!,
        'new entry value correct',
    );                                    # print_and_exit();
    $mech->content_contains(
        qq!name="name" value="$name"!,
        'new entry value correct',
    );                                    # print_and_exit();
    # incorrect - mistake in diagnostic category:
    $mech->content_lacks(
        qq!value="Myeloproliferative"!,
        'OK: expected diagnostic category value not present (yet)',
    );                                   # print_and_exit();
    $mech->content_contains(
        qq!value="T-lymphoproliferative"!,
        'OK: incorrect diagnostic category value detected',
    );                                   # print_and_exit();   
}

{
    # edit previously incorrect diagnostic category:
    $mech->follow_link(text => 'Edit', n => 2 );         # print_and_exit();
    
    $mech->field('diagnostic_category_id', 2);
    $mech->submit_form();                              # print_and_exit();
    
    # check for corrected mistake in diagnostic category:
    $mech->content_contains(
        qq!value="Myeloproliferative"!,
        'OK: expected diagnostic category value detected',
    );                                   # print_and_exit();
    $mech->content_lacks(
        qq!value="T-lymphoproliferative"!,
        'OK: incorrect diagnostic category value missing',
    );                                  # print_and_exit();
}

# edit incorrect spelling on name in 1st entry:
{
    $mech->follow_link(text => 'Edit', n => 1 );       # print_and_exit();
    
    # check for incorrect diagnosis name:
    $mech->content_contains(
        qq!value="Mantle cel lymphoma"!,
        'OK: incorrect diagnosis name detected',
    );                                  # print_and_exit();  
    
    $mech->field('name', 'Mantle cell lymphoma');
    $mech->submit_form();                     # print_and_exit();
 
    # check for corrected diagnosis name:
    $mech->content_contains(
        qq!value="Mantle cell lymphoma"!,
        'OK: correct diagnosis name detected',
    );                                  # print_and_exit();  
    # check for absence of corrected diagnosis name:
    $mech->content_lacks(
        qq!value="Mantle cel lymphoma"!,
        'OK: incorrect diagnosis name missing',
    );                                   # print_and_exit(); 
}

# inactivate 1st entry:
{
    # 1st check for absence of inactive record:
    $mech->content_lacks(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                  # print_and_exit(); 

    $mech->follow_link(text => 'Edit', n => 1 );       # print_and_exit();
    
    # check for correct entry:
    $mech->content_contains(
        qq!value="Mantle cell lymphoma"!,
        'OK: correct entry loaded',
    );                                   # print_and_exit();
    
    $mech->field('active', 'No');
    $mech->submit_form();                       # print_and_exit();

    # now check for presence of inactive flag (not specific to this records, but there's only 2):
    $mech->content_contains(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                  # print_and_exit();
}

# create new diagnostic term using 3rd diagnostic category:
{
    $mech->submit_form(
        fields => {
            name => 'Mycosis fungoides',
            icdo3 => '9700/3',
            diagnostic_category_id => 3,
        }
    );                                            # print_and_exit();
    
    # just check for all 3 diagnostic terms:
    my @terms = ( 'Mycosis fungoides', 'Mantle cell lymphoma', 'Systemic mastocytosis' );
    foreach (@terms) {
        $mech->content_contains(
            qq!value="$_"!,
            'OK: diagnostic term detected',
        );                                  # print_and_exit();
    }    
}

# do_logout(); logout link not available for admin function