package Role::RebuildTables;

use Moose::Role;
use Data::Dumper;

sub rebuild_tables {
    my $self  = shift;
    my $table = shift; # scalar or arrayref

	if ( ref $table eq 'ARRAY' ) {
		$self->rebuild($_) foreach @$table;
	}
	else {
		$self->rebuild($table);
	}
}

sub rebuild {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;

    my $dbh = $self->db->{dbh4};

    $dbh->do( qq!DROP TABLE IF EXISTS `$tbl`! ); 
	$dbh->do( $self->sql->{table}->{$tbl} );
}

sub clear_table {
	my ($self, $table) = @_;

	$self->db->{dbh4}->do( qq!truncate table $table!);
}

1;
