package LIMS::DB::Diagnosis;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'diagnoses',

    columns => [
        id                     => { type => 'serial', not_null => 1 },
        name                   => { type => 'varchar', length => 255 },
        icdo3                  => { type => 'varchar', length => 6 },
        diagnostic_category_id => { type => 'integer' },
        active                 => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'name' ],

    foreign_keys => [
        diagnostic_category => {
            class       => 'LIMS::DB::DiagnosticCategory',
            key_columns => { diagnostic_category_id => 'id' },
        },
    ],

    relationships => [
        auth_diagnosis_objs => {
            map_class => 'LIMS::DB::RequestAuthorisationDiagnosis',
            map_from  => 'report_diagnosis',
            map_to    => 'auth_diagnosis',
            type      => 'many to many',
        },

        context_warnings => {
            map_class => 'LIMS::DB::ContextWarningDiagnosis',
            map_from  => 'diagnosis',
            map_to    => 'context_warning',
            type      => 'many to many',
        },

        report_diagnosis_objs => {
            map_class => 'LIMS::DB::RequestAuthorisationDiagnosis',
            map_from  => 'auth_diagnosis',
            map_to    => 'report_diagnosis',
            type      => 'many to many',
        },

        request_authorisation_diagnosis => {
            class      => 'LIMS::DB::RequestAuthorisationDiagnosis',
            column_map => { id => 'auth_diagnosis_id' },
            type       => 'one to many',
        },

        request_authorisation_diagnosis_objs => { # what ???
            class      => 'LIMS::DB::RequestAuthorisationDiagnosis',
            column_map => { id => 'report_diagnosis_id' },
            type       => 'one to many',
        },

        request_diagnosis_history => {
            class      => 'LIMS::DB::RequestDiagnosisHistory',
            column_map => { id => 'diagnosis_id' },
            type       => 'one to many',
        },

        request_report => {
            class      => 'LIMS::DB::RequestReport',
            column_map => { id => 'diagnosis_id' },
            type       => 'one to many',
        },
    ],
);

# need to preserve convention: singular + 's' for Ajax::check_exists():
__PACKAGE__->meta->make_manager_class('diagnosiss');

1;